/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.blikoon.qrcodescanner.camera.CameraConfigurationManager;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = PreviewCallback.class.getName();
    private final CameraConfigurationManager mConfigManager;
    private Handler mPreviewHandler;
    private int mPreviewMessage;

    PreviewCallback(CameraConfigurationManager configManager) {
        this.mConfigManager = configManager;
    }

    void setHandler(Handler previewHandler, int previewMessage) {
        this.mPreviewHandler = previewHandler;
        this.mPreviewMessage = previewMessage;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Size cameraResolution = this.mConfigManager.getCameraResolution();
        if (this.mPreviewHandler != null) {
            Message message = this.mPreviewHandler.obtainMessage(this.mPreviewMessage, cameraResolution.width, cameraResolution.height, (Object)data);
            message.sendToTarget();
            this.mPreviewHandler = null;
        } else {
            Log.v((String)TAG, (String)"no handler callback.");
        }
    }
}

