/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.camera;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.view.SurfaceHolder;
import com.blikoon.qrcodescanner.camera.AutoFocusCallback;
import com.blikoon.qrcodescanner.camera.CameraConfigurationManager;
import com.blikoon.qrcodescanner.camera.PreviewCallback;
import java.io.IOException;
import java.util.List;

public final class CameraManager {
    private static CameraManager sCameraManager;
    private final CameraConfigurationManager mConfigManager;
    private Camera mCamera;
    private boolean mInitialized;
    private boolean mPreviewing;
    private final PreviewCallback mPreviewCallback;
    private final AutoFocusCallback mAutoFocusCallback;

    public static void init(Context context) {
        if (sCameraManager == null) {
            sCameraManager = new CameraManager(context);
        }
    }

    public static CameraManager get() {
        return sCameraManager;
    }

    private CameraManager(Context context) {
        this.mConfigManager = new CameraConfigurationManager(context);
        this.mPreviewCallback = new PreviewCallback(this.mConfigManager);
        this.mAutoFocusCallback = new AutoFocusCallback();
    }

    public void openDriver(SurfaceHolder holder) throws IOException {
        if (this.mCamera == null) {
            this.mCamera = Camera.open();
            if (this.mCamera == null) {
                throw new IOException();
            }
            this.mCamera.setPreviewDisplay(holder);
            if (!this.mInitialized) {
                this.mInitialized = true;
                this.mConfigManager.initFromCameraParameters(this.mCamera);
            }
            this.mConfigManager.setDesiredCameraParameters(this.mCamera);
        }
    }

    public boolean setFlashLight(boolean open) {
        if (this.mCamera == null) {
            return false;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (parameters == null) {
            return false;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (null == flashModes || 0 == flashModes.size()) {
            return false;
        }
        String flashMode = parameters.getFlashMode();
        if (open) {
            if ("torch".equals(flashMode)) {
                return true;
            }
            if (flashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.mCamera.setParameters(parameters);
                return true;
            }
            return false;
        }
        if ("off".equals(flashMode)) {
            return true;
        }
        if (flashModes.contains("off")) {
            parameters.setFlashMode("off");
            this.mCamera.setParameters(parameters);
            return true;
        }
        return false;
    }

    public void closeDriver() {
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mInitialized = false;
            this.mPreviewing = false;
            this.mCamera = null;
        }
    }

    public void startPreview() {
        if (this.mCamera != null && !this.mPreviewing) {
            this.mCamera.startPreview();
            this.mPreviewing = true;
        }
    }

    public void stopPreview() {
        if (this.mCamera != null && this.mPreviewing) {
            this.mCamera.stopPreview();
            this.mPreviewCallback.setHandler(null, 0);
            this.mAutoFocusCallback.setHandler(null, 0);
            this.mPreviewing = false;
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        if (this.mCamera != null && this.mPreviewing) {
            this.mPreviewCallback.setHandler(handler, message);
            this.mCamera.setOneShotPreviewCallback((Camera.PreviewCallback)this.mPreviewCallback);
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (this.mCamera != null && this.mPreviewing) {
            this.mAutoFocusCallback.setHandler(handler, message);
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this.mAutoFocusCallback);
        }
    }
}

