/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.camera;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import com.blikoon.qrcodescanner.utils.ScreenUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final String TAG = CameraConfigurationManager.class.getName();
    private static final int TEN_DESIRED_ZOOM = 10;
    private static final int DESIRED_SHARPNESS = 30;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private Camera.Size mCameraResolution;
    private Camera.Size mPictureResolution;
    private Context mContext;

    CameraConfigurationManager(Context context) {
        this.mContext = context;
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        this.mCameraResolution = this.findCloselySize(ScreenUtils.getScreenWidth(this.mContext), ScreenUtils.getScreenHeight(this.mContext), parameters.getSupportedPreviewSizes());
        Log.e((String)TAG, (String)("Setting preview size: " + this.mCameraResolution.width + "-" + this.mCameraResolution.height));
        this.mPictureResolution = this.findCloselySize(ScreenUtils.getScreenWidth(this.mContext), ScreenUtils.getScreenHeight(this.mContext), parameters.getSupportedPictureSizes());
        Log.e((String)TAG, (String)("Setting picture size: " + this.mPictureResolution.width + "-" + this.mPictureResolution.height));
    }

    void setDesiredCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPreviewSize(this.mCameraResolution.width, this.mCameraResolution.height);
        parameters.setPictureSize(this.mPictureResolution.width, this.mPictureResolution.height);
        this.setZoom(parameters);
        camera.setDisplayOrientation(90);
        camera.setParameters(parameters);
    }

    Camera.Size getCameraResolution() {
        return this.mCameraResolution;
    }

    private static Point getCameraResolution(Camera.Parameters parameters, Point screenResolution) {
        String previewSizeValueString = parameters.get("preview-size-values");
        if (previewSizeValueString == null) {
            previewSizeValueString = parameters.get("preview-size-value");
        }
        Point cameraResolution = null;
        if (previewSizeValueString != null) {
            Log.e((String)TAG, (String)("preview-size-values parameter: " + previewSizeValueString));
            cameraResolution = CameraConfigurationManager.findBestPreviewSizeValue(previewSizeValueString, screenResolution);
        }
        if (cameraResolution == null) {
            cameraResolution = new Point(screenResolution.x >> 3 << 3, screenResolution.y >> 3 << 3);
        }
        return cameraResolution;
    }

    private static Point findBestPreviewSizeValue(CharSequence previewSizeValueString, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        for (String previewSize : COMMA_PATTERN.split(previewSizeValueString)) {
            int newX;
            int newY;
            int dimPosition = (previewSize = previewSize.trim()).indexOf(120);
            if (dimPosition < 0) {
                Log.e((String)TAG, (String)("Bad preview-size: " + previewSize));
                continue;
            }
            try {
                newY = Integer.parseInt(previewSize.substring(0, dimPosition));
                newX = Integer.parseInt(previewSize.substring(dimPosition + 1));
            }
            catch (NumberFormatException nfe) {
                Log.e((String)TAG, (String)("Bad preview-size: " + previewSize));
                continue;
            }
            int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
            if (newDiff == 0) {
                bestX = newX;
                bestY = newY;
                break;
            }
            if (newDiff >= diff) continue;
            bestX = newX;
            bestY = newY;
            diff = newDiff;
        }
        if (bestX > 0 && bestY > 0) {
            return new Point(bestX, bestY);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringValues, int tenDesiredZoom) {
        int tenBestValue = 0;
        for (String stringValue : COMMA_PATTERN.split(stringValues)) {
            double value;
            stringValue = stringValue.trim();
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException nfe) {
                return tenDesiredZoom;
            }
            int tenValue = (int)(10.0 * value);
            if (!(Math.abs((double)tenDesiredZoom - value) < (double)Math.abs(tenDesiredZoom - tenBestValue))) continue;
            tenBestValue = tenValue;
        }
        return tenBestValue;
    }

    private void setZoom(Camera.Parameters parameters) {
        String motZoomStepString;
        String motZoomValuesString;
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 10;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Log.e((String)TAG, (String)("Bad max-zoom: " + maxZoomString));
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                Log.e((String)TAG, (String)("Bad taking-picture-zoom-max: " + takingPictureZoomMaxString));
            }
        }
        if ((motZoomValuesString = parameters.get("mot-zoom-values")) != null) {
            tenDesiredZoom = CameraConfigurationManager.findBestMotZoomValue(motZoomValuesString, tenDesiredZoom);
        }
        if ((motZoomStepString = parameters.get("mot-zoom-step")) != null) {
            try {
                double motZoomStep = Double.parseDouble(motZoomStepString.trim());
                int tenZoomStep = (int)(10.0 * motZoomStep);
                if (tenZoomStep > 1) {
                    tenDesiredZoom -= tenDesiredZoom % tenZoomStep;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parameters.isZoomSupported()) {
            Log.e((String)TAG, (String)("max-zoom:" + parameters.getMaxZoom()));
            parameters.setZoom(parameters.getMaxZoom() / 10);
        } else {
            Log.e((String)TAG, (String)"Unsupported zoom.");
        }
    }

    public static int getDesiredSharpness() {
        return 30;
    }

    protected Camera.Size findCloselySize(int surfaceWidth, int surfaceHeight, List<Camera.Size> preSizeList) {
        Collections.sort(preSizeList, new SizeComparator(surfaceWidth, surfaceHeight));
        return preSizeList.get(0);
    }

    private static class SizeComparator
    implements Comparator<Camera.Size> {
        private final int width;
        private final int height;
        private final float ratio;

        SizeComparator(int width, int height) {
            if (width < height) {
                this.width = height;
                this.height = width;
            } else {
                this.width = width;
                this.height = height;
            }
            this.ratio = (float)this.height / (float)this.width;
        }

        @Override
        public int compare(Camera.Size size1, Camera.Size size2) {
            float ratio2;
            int width1 = size1.width;
            int height1 = size1.height;
            int width2 = size2.width;
            int height2 = size2.height;
            float ratio1 = Math.abs((float)height1 / (float)width1 - this.ratio);
            int result = Float.compare(ratio1, ratio2 = Math.abs((float)height2 / (float)width2 - this.ratio));
            if (result != 0) {
                return result;
            }
            int minGap1 = Math.abs(this.width - width1) + Math.abs(this.height - height1);
            int minGap2 = Math.abs(this.width - width2) + Math.abs(this.height - height2);
            return minGap1 - minGap2;
        }
    }
}

