/*
 * Decompiled with CFR 0.152.
 */
package com.tomash.androidcontacts.contactgetter.main.contactsGetter;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import android.util.SparseArray;
import com.tomash.androidcontacts.contactgetter.entity.Address;
import com.tomash.androidcontacts.contactgetter.entity.ContactData;
import com.tomash.androidcontacts.contactgetter.entity.Email;
import com.tomash.androidcontacts.contactgetter.entity.Group;
import com.tomash.androidcontacts.contactgetter.entity.IMAddress;
import com.tomash.androidcontacts.contactgetter.entity.NameData;
import com.tomash.androidcontacts.contactgetter.entity.Organization;
import com.tomash.androidcontacts.contactgetter.entity.PhoneNumber;
import com.tomash.androidcontacts.contactgetter.entity.Relation;
import com.tomash.androidcontacts.contactgetter.entity.SpecialDate;
import com.tomash.androidcontacts.contactgetter.interfaces.WithLabel;
import com.tomash.androidcontacts.contactgetter.main.FieldType;
import java.util.ArrayList;
import java.util.List;

class ContactsGetter {
    private ContentResolver mResolver;
    private Context mCtx;
    private List<FieldType> mEnabledFields;
    private String[] mSelectionArgs;
    private String mSorting;
    private String mSelection;
    private static final String MAIN_DATA_KEY = "data1";
    private static final String LABEL_DATA_KEY = "data2";
    private static final String CUSTOM_LABEL_DATA_KEY = "data3";
    private static final String ID_KEY = "contact_id";
    private static final String[] WITH_LABEL_PROJECTION = new String[]{"contact_id", "data1", "data2", "data3"};
    private static final String[] CONTACTS_PROJECTION = new String[]{"_id", "contact_last_updated_timestamp", "photo_uri", "lookup", "display_name", "starred"};
    private static final String[] CONTACTS_PROJECTION_LOW_API = new String[]{"_id", "photo_uri", "lookup", "display_name", "starred"};
    private static final String[] ADDITIONAL_DATA_PROJECTION = new String[]{"_id", "account_type", "account_name"};
    private Class<? extends ContactData> mContactDataClass;

    ContactsGetter(Context ctx, List<FieldType> enabledFields, String sorting, String[] selectionArgs, String selection) {
        this.mCtx = ctx;
        this.mResolver = ctx.getContentResolver();
        this.mEnabledFields = enabledFields;
        this.mSelectionArgs = selectionArgs;
        this.mSorting = sorting;
        this.mSelection = selection;
    }

    ContactsGetter setContactDataClass(Class<? extends ContactData> mContactDataClass) {
        this.mContactDataClass = mContactDataClass;
        return this;
    }

    private Cursor getContactsCursorWithSelection(String ordering, String selection, String[] selectionArgs) {
        return this.mResolver.query(ContactsContract.Contacts.CONTENT_URI, Build.VERSION.SDK_INT > 17 ? CONTACTS_PROJECTION : CONTACTS_PROJECTION_LOW_API, selection, selectionArgs, ordering);
    }

    private Cursor getContactsCursorWithAdditionalData() {
        return this.mResolver.query(ContactsContract.RawContacts.CONTENT_URI, ADDITIONAL_DATA_PROJECTION, null, null, null);
    }

    private <T extends ContactData> T getContactData() {
        if (this.mContactDataClass == null) {
            return (T)new ContactData(){};
        }
        try {
            return (T)this.mContactDataClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    <T extends ContactData> List<T> getContacts() {
        int id;
        SparseArray groupsDataMap;
        Cursor mainCursor = this.getContactsCursorWithSelection(this.mSorting, this.mSelection, this.mSelectionArgs);
        Cursor additionalDataCursor = this.getContactsCursorWithAdditionalData();
        SparseArray contactsSparse = new SparseArray();
        ArrayList<ContactData> result = new ArrayList<ContactData>();
        if (mainCursor == null) {
            return result;
        }
        SparseArray<List<PhoneNumber>> phonesDataMap = this.mEnabledFields.contains((Object)FieldType.PHONE_NUMBERS) ? this.getDataMap(this.getCursorFromContentType(WITH_LABEL_PROJECTION, "vnd.android.cursor.item/phone_v2"), new WithLabelCreator<PhoneNumber>(){

            @Override
            public PhoneNumber create(String mainData, int contactId, int labelId, String labelName) {
                PhoneNumber number = labelName != null ? new PhoneNumber(mainData, labelName) : new PhoneNumber(ContactsGetter.this.mCtx, mainData, labelId);
                number.setContactId(contactId);
                return number;
            }
        }) : new SparseArray<List<PhoneNumber>>();
        SparseArray<List<Address>> addressDataMap = this.mEnabledFields.contains((Object)FieldType.ADDRESS) ? this.getDataMap(this.getCursorFromContentType(WITH_LABEL_PROJECTION, "vnd.android.cursor.item/postal-address_v2"), new WithLabelCreator<Address>(){

            @Override
            public Address create(String mainData, int contactId, int labelId, String labelName) {
                Address address = labelName != null ? new Address(mainData, labelName) : new Address(ContactsGetter.this.mCtx, mainData, labelId);
                address.setContactId(contactId);
                return address;
            }
        }) : new SparseArray<List<Address>>();
        SparseArray<List<Email>> emailDataMap = this.mEnabledFields.contains((Object)FieldType.EMAILS) ? this.getDataMap(this.getCursorFromContentType(WITH_LABEL_PROJECTION, "vnd.android.cursor.item/email_v2"), new WithLabelCreator<Email>(){

            @Override
            public Email create(String mainData, int contactId, int labelId, String labelName) {
                Email email = labelName != null ? new Email(mainData, labelName) : new Email(ContactsGetter.this.mCtx, mainData, labelId);
                email.setContactId(contactId);
                return email;
            }
        }) : new SparseArray<List<Email>>();
        SparseArray<List<SpecialDate>> specialDateMap = this.mEnabledFields.contains((Object)FieldType.SPECIAL_DATES) ? this.getDataMap(this.getCursorFromContentType(WITH_LABEL_PROJECTION, "vnd.android.cursor.item/contact_event"), new WithLabelCreator<SpecialDate>(){

            @Override
            public SpecialDate create(String mainData, int contactId, int labelId, String labelName) {
                SpecialDate specialData = labelName != null ? new SpecialDate(mainData, labelName) : new SpecialDate(ContactsGetter.this.mCtx, mainData, labelId);
                specialData.setContactId(contactId);
                return specialData;
            }
        }) : new SparseArray<List<SpecialDate>>();
        SparseArray<List<Relation>> relationMap = this.mEnabledFields.contains((Object)FieldType.RELATIONS) ? this.getDataMap(this.getCursorFromContentType(WITH_LABEL_PROJECTION, "vnd.android.cursor.item/relation"), new WithLabelCreator<Relation>(){

            @Override
            public Relation create(String mainData, int contactId, int labelId, String labelName) {
                Relation relation = labelName != null ? new Relation(mainData, labelName) : new Relation(ContactsGetter.this.mCtx, mainData, labelId);
                relation.setContactId(contactId);
                return relation;
            }
        }) : new SparseArray<List<Relation>>();
        SparseArray imAddressesDataMap = this.mEnabledFields.contains((Object)FieldType.IM_ADDRESSES) ? this.getIMAddressesMap() : new SparseArray();
        SparseArray websitesDataMap = this.mEnabledFields.contains((Object)FieldType.WEBSITES) ? this.getWebSitesMap() : new SparseArray();
        SparseArray notesDataMap = this.mEnabledFields.contains((Object)FieldType.NOTES) ? this.getStringDataMap("vnd.android.cursor.item/note") : new SparseArray();
        SparseArray nicknameDataMap = this.mEnabledFields.contains((Object)FieldType.NICKNAME) ? this.getStringDataMap("vnd.android.cursor.item/nickname") : new SparseArray();
        SparseArray sipDataMap = this.mEnabledFields.contains((Object)FieldType.SIP) ? this.getStringDataMap("vnd.android.cursor.item/sip_address") : new SparseArray();
        SparseArray organisationDataMap = this.mEnabledFields.contains((Object)FieldType.ORGANIZATION) ? this.getOrganizationDataMap() : new SparseArray();
        SparseArray nameDataMap = this.mEnabledFields.contains((Object)FieldType.NAME_DATA) ? this.getNameDataMap() : new SparseArray();
        SparseArray sparseArray = groupsDataMap = this.mEnabledFields.contains((Object)FieldType.GROUPS) ? this.getGroupsDataMap() : new SparseArray();
        while (mainCursor.moveToNext()) {
            id = mainCursor.getInt(mainCursor.getColumnIndex("_id"));
            long date = 0L;
            if (Build.VERSION.SDK_INT > 17) {
                date = mainCursor.getLong(mainCursor.getColumnIndex("contact_last_updated_timestamp"));
            }
            String photoUriString = mainCursor.getString(mainCursor.getColumnIndex("photo_uri"));
            String lookupKey = mainCursor.getString(mainCursor.getColumnIndex("lookup"));
            boolean isFavorite = mainCursor.getInt(mainCursor.getColumnIndex("starred")) == 1;
            Uri photoUri = photoUriString == null ? Uri.EMPTY : Uri.parse((String)photoUriString);
            ContactData data = ((ContactData)this.getContactData()).setContactId(id).setLookupKey(lookupKey).setLastModificationDate(date).setPhoneList((List)phonesDataMap.get(id)).setAddressesList((List)addressDataMap.get(id)).setEmailList((List)emailDataMap.get(id)).setWebsitesList((List)websitesDataMap.get(id)).setNote((String)notesDataMap.get(id)).setImAddressesList((List)imAddressesDataMap.get(id)).setRelationsList((List)relationMap.get(id)).setSpecialDatesList((List)specialDateMap.get(id)).setNickName((String)nicknameDataMap.get(id)).setOrganization((Organization)organisationDataMap.get(id)).setSipAddress((String)sipDataMap.get(id)).setNameData((NameData)nameDataMap.get(id)).setPhotoUri(photoUri).setFavorite(isFavorite).setGroupList((List)groupsDataMap.get(id)).setCompositeName(mainCursor.getString(mainCursor.getColumnIndex("display_name")));
            contactsSparse.put(id, (Object)data);
            result.add(data);
        }
        mainCursor.close();
        while (additionalDataCursor.moveToNext()) {
            id = additionalDataCursor.getInt(additionalDataCursor.getColumnIndex("_id"));
            ContactData relatedContactData = (ContactData)contactsSparse.get(id);
            if (relatedContactData == null) continue;
            String accountType = additionalDataCursor.getString(additionalDataCursor.getColumnIndex("account_type"));
            String accountName = additionalDataCursor.getString(additionalDataCursor.getColumnIndex("account_name"));
            relatedContactData.setAccountName(accountName).setAccountType(accountType);
        }
        additionalDataCursor.close();
        return result;
    }

    private SparseArray<List<String>> getWebSitesMap() {
        SparseArray idSiteMap = new SparseArray();
        Cursor websiteCur = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY}, "vnd.android.cursor.item/website");
        if (websiteCur != null) {
            while (websiteCur.moveToNext()) {
                int id = websiteCur.getInt(websiteCur.getColumnIndex(ID_KEY));
                String website = websiteCur.getString(websiteCur.getColumnIndex(MAIN_DATA_KEY));
                ArrayList<String> currentWebsiteList = (ArrayList<String>)idSiteMap.get(id);
                if (currentWebsiteList == null) {
                    currentWebsiteList = new ArrayList<String>();
                    currentWebsiteList.add(website);
                    idSiteMap.put(id, currentWebsiteList);
                    continue;
                }
                currentWebsiteList.add(website);
            }
            websiteCur.close();
        }
        return idSiteMap;
    }

    private SparseArray<Group> getGroupsMap() {
        SparseArray idGroupMap = new SparseArray();
        Cursor groupCursor = this.mResolver.query(ContactsContract.Groups.CONTENT_URI, new String[]{"_id", "title"}, null, null, null);
        if (groupCursor != null) {
            while (groupCursor.moveToNext()) {
                int id = groupCursor.getInt(groupCursor.getColumnIndex("_id"));
                String title = groupCursor.getString(groupCursor.getColumnIndex("title"));
                idGroupMap.put(id, (Object)new Group().setGroupId(id).setGroupTitle(title));
            }
            groupCursor.close();
        }
        return idGroupMap;
    }

    private SparseArray<List<Group>> getGroupsDataMap() {
        SparseArray idListGroupMap = new SparseArray();
        SparseArray<Group> groupMapById = this.getGroupsMap();
        Cursor groupMembershipCursor = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY}, "vnd.android.cursor.item/group_membership");
        if (groupMembershipCursor != null) {
            while (groupMembershipCursor.moveToNext()) {
                int id = groupMembershipCursor.getInt(groupMembershipCursor.getColumnIndex(ID_KEY));
                int groupId = groupMembershipCursor.getInt(groupMembershipCursor.getColumnIndex(MAIN_DATA_KEY));
                ArrayList<Object> currentIdGroupList = (ArrayList<Object>)idListGroupMap.get(id);
                if (currentIdGroupList == null) {
                    currentIdGroupList = new ArrayList<Object>();
                    currentIdGroupList.add(groupMapById.get(groupId));
                    idListGroupMap.put(id, currentIdGroupList);
                    continue;
                }
                currentIdGroupList.add(groupMapById.get(groupId));
            }
            groupMembershipCursor.close();
        }
        return idListGroupMap;
    }

    private SparseArray<NameData> getNameDataMap() {
        Cursor nameCursor = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY, LABEL_DATA_KEY, "data8", "data9", CUSTOM_LABEL_DATA_KEY, "data4", "data5", "data6", "data7"}, "vnd.android.cursor.item/name");
        SparseArray nameDataSparseArray = new SparseArray();
        if (nameCursor != null) {
            while (nameCursor.moveToNext()) {
                int id = nameCursor.getInt(nameCursor.getColumnIndex(ID_KEY));
                if (nameDataSparseArray.get(id) != null) continue;
                nameDataSparseArray.put(id, (Object)new NameData().setFullName(nameCursor.getString(nameCursor.getColumnIndex(MAIN_DATA_KEY))).setFirstName(nameCursor.getString(nameCursor.getColumnIndex(LABEL_DATA_KEY))).setSurname(nameCursor.getString(nameCursor.getColumnIndex(CUSTOM_LABEL_DATA_KEY))).setNamePrefix(nameCursor.getString(nameCursor.getColumnIndex("data4"))).setMiddleName(nameCursor.getString(nameCursor.getColumnIndex("data5"))).setNameSuffix(nameCursor.getString(nameCursor.getColumnIndex("data6"))).setPhoneticFirst(nameCursor.getString(nameCursor.getColumnIndex("data7"))).setPhoneticMiddle(nameCursor.getString(nameCursor.getColumnIndex("data8"))).setPhoneticLast(nameCursor.getString(nameCursor.getColumnIndex("data9"))));
            }
            nameCursor.close();
        }
        return nameDataSparseArray;
    }

    private SparseArray<List<IMAddress>> getIMAddressesMap() {
        SparseArray idImAddressMap = new SparseArray();
        Cursor cur = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY, "data5", "data6"}, "vnd.android.cursor.item/im");
        if (cur != null) {
            while (cur.moveToNext()) {
                int id = cur.getInt(cur.getColumnIndex(ID_KEY));
                String data = cur.getString(cur.getColumnIndex(MAIN_DATA_KEY));
                int labelId = cur.getInt(cur.getColumnIndex("data5"));
                String customLabel = cur.getString(cur.getColumnIndex("data6"));
                IMAddress current = customLabel == null ? new IMAddress(this.mCtx, data, labelId) : new IMAddress(data, customLabel);
                ArrayList<IMAddress> currentWebsiteList = (ArrayList<IMAddress>)idImAddressMap.get(id);
                if (currentWebsiteList == null) {
                    currentWebsiteList = new ArrayList<IMAddress>();
                    currentWebsiteList.add(current);
                    idImAddressMap.put(id, currentWebsiteList);
                    continue;
                }
                currentWebsiteList.add(current);
            }
            cur.close();
        }
        return idImAddressMap;
    }

    private SparseArray<String> getStringDataMap(String contentType) {
        SparseArray idNoteMap = new SparseArray();
        Cursor noteCur = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY}, contentType);
        if (noteCur != null) {
            while (noteCur.moveToNext()) {
                int id = noteCur.getInt(noteCur.getColumnIndex(ID_KEY));
                String note = noteCur.getString(noteCur.getColumnIndex(MAIN_DATA_KEY));
                if (note == null) continue;
                idNoteMap.put(id, (Object)note);
            }
            noteCur.close();
        }
        return idNoteMap;
    }

    private SparseArray<Organization> getOrganizationDataMap() {
        SparseArray idOrganizationMap = new SparseArray();
        Cursor noteCur = this.getCursorFromContentType(new String[]{ID_KEY, MAIN_DATA_KEY, "data4"}, "vnd.android.cursor.item/organization");
        if (noteCur != null) {
            while (noteCur.moveToNext()) {
                int id = noteCur.getInt(noteCur.getColumnIndex(ID_KEY));
                String organizationName = noteCur.getString(noteCur.getColumnIndex(MAIN_DATA_KEY));
                String organizationTitle = noteCur.getString(noteCur.getColumnIndex("data4"));
                idOrganizationMap.put(id, (Object)new Organization().setName(organizationName).setTitle(organizationTitle));
            }
            noteCur.close();
        }
        return idOrganizationMap;
    }

    private <T extends WithLabel> SparseArray<List<T>> getDataMap(Cursor dataCursor, WithLabelCreator<T> creator) {
        SparseArray dataSparseArray = new SparseArray();
        if (dataCursor != null) {
            while (dataCursor.moveToNext()) {
                int id = dataCursor.getInt(dataCursor.getColumnIndex(ID_KEY));
                String data = dataCursor.getString(dataCursor.getColumnIndex(MAIN_DATA_KEY));
                int labelId = dataCursor.getInt(dataCursor.getColumnIndex(LABEL_DATA_KEY));
                String customLabel = dataCursor.getString(dataCursor.getColumnIndex(CUSTOM_LABEL_DATA_KEY));
                T current = creator.create(data, id, labelId, customLabel);
                ArrayList<T> currentDataList = (ArrayList<T>)dataSparseArray.get(id);
                if (currentDataList == null) {
                    currentDataList = new ArrayList<T>();
                    currentDataList.add(current);
                    dataSparseArray.put(id, currentDataList);
                    continue;
                }
                currentDataList.add(current);
            }
            dataCursor.close();
        }
        return dataSparseArray;
    }

    private Cursor getCursorFromContentType(String[] projection, String contentType) {
        String orgWhere = "mimetype = ?";
        String[] orgWhereParams = new String[]{contentType};
        return this.mResolver.query(ContactsContract.Data.CONTENT_URI, projection, orgWhere, orgWhereParams, null);
    }

    static interface WithLabelCreator<T extends WithLabel> {
        public T create(String var1, int var2, int var3, String var4);
    }
}

