/*
 * Decompiled with CFR 0.152.
 */
package com.tomash.androidcontacts.contactgetter.interfaces;

import android.content.Context;

public abstract class WithLabel {
    private String mainData;
    private int contactId;
    private int labelId;
    private String labelName;

    public WithLabel(String mainData, String labelName) {
        this.mainData = mainData;
        this.contactId = -1;
        this.labelId = this.getCustomLabelId();
        this.labelName = labelName;
    }

    public WithLabel(Context ctx, String mainData, int labelId) {
        this.mainData = mainData;
        this.contactId = -1;
        this.labelId = this.isValidLabel(labelId) ? labelId : this.getDefaultLabelId();
        this.labelName = this.getLabelNameResId(ctx, labelId);
    }

    public WithLabel(Context ctx, String mainData) {
        this.mainData = mainData;
        this.contactId = -1;
        this.labelId = this.getDefaultLabelId();
        this.labelName = this.getLabelNameResId(ctx, this.labelId);
    }

    protected abstract String getLabelNameResId(Context var1, int var2);

    protected abstract int getDefaultLabelId();

    protected abstract boolean isValidLabel(int var1);

    public abstract int getCustomLabelId();

    public WithLabel() {
    }

    public String getMainData() {
        return this.mainData;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getLabelId() {
        return this.labelId;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WithLabel withLabel = (WithLabel)o;
        if (this.labelId != withLabel.labelId) {
            return false;
        }
        if (!this.mainData.equals(withLabel.mainData)) {
            return false;
        }
        return this.labelName.equals(withLabel.labelName);
    }

    public WithLabel setMainData(String mainData) {
        this.mainData = mainData;
        return this;
    }

    public WithLabel setContactId(int contactId) {
        this.contactId = contactId;
        return this;
    }

    public WithLabel setLabelId(int labelId) {
        this.labelId = labelId;
        return this;
    }

    public WithLabel setLabelName(String labelName) {
        this.labelName = labelName;
        return this;
    }

    public int hashCode() {
        return this.mainData.hashCode();
    }
}

