/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjornvester.wsdl2java;

import com.github.bjornvester.wsdl2java.Wsdl2JavaPluginExtension;
import com.github.bjornvester.wsdl2java.Wsdl2JavaWorkerParams;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTree;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/bjornvester/wsdl2java/Wsdl2JavaWorker;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/bjornvester/wsdl2java/Wsdl2JavaWorkerParams;", "()V", "logger", "Lorg/slf4j/Logger;", "execute", "", "fixGeneratedAnnotations", "wsdl2java-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nWsdl2JavaWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wsdl2JavaWorker.kt\ncom/github/bjornvester/wsdl2java/Wsdl2JavaWorker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n215#2:68\n216#2:71\n37#3,2:69\n1855#4,2:72\n*S KotlinDebug\n*F\n+ 1 Wsdl2JavaWorker.kt\ncom/github/bjornvester/wsdl2java/Wsdl2JavaWorker\n*L\n14#1:68\n14#1:71\n18#1:69,2\n36#1:72,2\n*E\n"})
public abstract class Wsdl2JavaWorker
implements WorkAction<Wsdl2JavaWorkerParams> {
    @NotNull
    private final Logger logger;

    public Wsdl2JavaWorker() {
        Logger logger = LoggerFactory.getLogger(Wsdl2JavaWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Wsdl2JavaWorker::class.java)");
        this.logger = logger;
    }

    public void execute() {
        Map<String, List<String>> $this$forEach$iv = ((Wsdl2JavaWorkerParams)this.getParameters()).getWsdlToArgs();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            String wsdlPath = entry.getKey();
            List<String> args = entry.getValue();
            this.logger.info("Running WSDLToJava tool on file {} with args: {}", (Object)wsdlPath, args);
            try {
                Collection $this$toTypedArray$iv = args;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                new WSDLToJava(thisCollection$iv.toArray(new String[0])).run(new ToolContext());
            }
            catch (Exception e) {
                this.logger.error("Failed to generate sources from WSDL:");
                e.printStackTrace();
                throw new GradleException("Failed to generate Java sources from WSDL. See the log for details.");
            }
        }
        this.fixGeneratedAnnotations();
    }

    private final void fixGeneratedAnnotations() {
        if (!Intrinsics.areEqual((Object)((Wsdl2JavaWorkerParams)this.getParameters()).getGeneratedStyle(), (Object)Wsdl2JavaPluginExtension.Companion.getGENERATED_STYLE_DEFAULT()) || ((Wsdl2JavaWorkerParams)this.getParameters()).getRemoveDateFromGeneratedAnnotation()) {
            FileTree fileTree = ((Wsdl2JavaWorkerParams)this.getParameters()).getOutputDir().getAsFileTree();
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"parameters.outputDir.asFileTree");
            Iterable $this$forEach$iv = (Iterable)fileTree;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                this.logger.debug("Fixing the @Generated annotation in file {}", (Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String source = FilesKt.readText$default((File)it, null, (int)1, null);
                String string = ((Wsdl2JavaWorkerParams)this.getParameters()).getGeneratedStyle();
                if (Intrinsics.areEqual((Object)string, (Object)Wsdl2JavaPluginExtension.Companion.getGENERATED_STYLE_JDK8())) {
                    source = StringsKt.replaceFirst$default((String)source, (String)"import jakarta.annotation.Generated", (String)"import javax.annotation.Generated", (boolean)false, (int)4, null);
                } else if (Intrinsics.areEqual((Object)string, (Object)Wsdl2JavaPluginExtension.Companion.getGENERATED_STYLE_JDK9())) {
                    source = StringsKt.replaceFirst$default((String)source, (String)"import jakarta.annotation.Generated", (String)"import javax.annotation.processing.Generated", (boolean)false, (int)4, null);
                    source = StringsKt.replaceFirst$default((String)source, (String)"import javax.annotation.Generated", (String)"import javax.annotation.processing.Generated", (boolean)false, (int)4, null);
                } else if (Intrinsics.areEqual((Object)string, (Object)Wsdl2JavaPluginExtension.Companion.getGENERATED_STYLE_JAKARTA())) {
                    source = StringsKt.replaceFirst$default((String)source, (String)"import javax.annotation.Generated", (String)"jakarta.annotation.Generated", (boolean)false, (int)4, null);
                }
                if (((Wsdl2JavaWorkerParams)this.getParameters()).getRemoveDateFromGeneratedAnnotation()) {
                    String generatedPattern = "(@Generated\\(value = .*?\"), date = \"[^\"]*\"([^)]*\\))";
                    CharSequence charSequence = source;
                    Regex regex = new Regex(generatedPattern);
                    String string2 = "$1$2";
                    source = regex.replace(charSequence, string2);
                }
                FilesKt.writeText$default((File)it, (String)source, null, (int)2, null);
            }
        }
    }
}

