/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.badgeview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import cn.bingoogolapple.badgeview.BGABadgeViewUtil;
import cn.bingoogolapple.badgeview.BGADragBadgeView;
import java.util.Random;

public class BGAExplosionAnimator
extends ValueAnimator {
    public static final int ANIM_DURATION = 300;
    private static final Interpolator DEFAULT_INTERPOLATOR = new AccelerateInterpolator(0.6f);
    private static final float END_VALUE = 1.4f;
    private static final int REFRESH_RATIO = 3;
    private static float X;
    private static float Y;
    private static float V;
    private static float W;
    private Particle[] mParticles;
    private Paint mPaint;
    private BGADragBadgeView mDragBadgeView;
    private Rect mRect;
    private Rect mInvalidateRect;

    public BGAExplosionAnimator(BGADragBadgeView dragBadgeView, Rect rect, Bitmap bitmap) {
        this.setFloatValues(new float[]{0.0f, 1.4f});
        this.setDuration(300L);
        this.setInterpolator((TimeInterpolator)DEFAULT_INTERPOLATOR);
        X = BGABadgeViewUtil.dp2px(dragBadgeView.getContext(), 5.0f);
        Y = BGABadgeViewUtil.dp2px(dragBadgeView.getContext(), 20.0f);
        V = BGABadgeViewUtil.dp2px(dragBadgeView.getContext(), 2.0f);
        W = BGABadgeViewUtil.dp2px(dragBadgeView.getContext(), 1.0f);
        this.mPaint = new Paint();
        this.mDragBadgeView = dragBadgeView;
        this.mRect = rect;
        this.mInvalidateRect = new Rect(this.mRect.left - this.mRect.width() * 3, this.mRect.top - this.mRect.height() * 3, this.mRect.right + this.mRect.width() * 3, this.mRect.bottom + this.mRect.height() * 3);
        int partLen = 15;
        this.mParticles = new Particle[partLen * partLen];
        Random random = new Random(System.currentTimeMillis());
        int w = bitmap.getWidth() / (partLen + 2);
        int h = bitmap.getHeight() / (partLen + 2);
        for (int i = 0; i < partLen; ++i) {
            for (int j = 0; j < partLen; ++j) {
                this.mParticles[i * partLen + j] = this.generateParticle(bitmap.getPixel((j + 1) * w, (i + 1) * h), random);
            }
        }
    }

    private Particle generateParticle(int color, Random random) {
        float f;
        Particle particle = new Particle();
        particle.color = color;
        particle.radius = V;
        particle.baseRadius = random.nextFloat() < 0.2f ? V + (X - V) * random.nextFloat() : W + (V - W) * random.nextFloat();
        float nextFloat = random.nextFloat();
        particle.top = (float)this.mRect.height() * (0.18f * random.nextFloat() + 0.2f);
        particle.top = nextFloat < 0.2f ? particle.top : particle.top + particle.top * 0.2f * random.nextFloat();
        particle.bottom = (float)this.mRect.height() * (random.nextFloat() - 0.5f) * 1.8f;
        particle.bottom = f = nextFloat < 0.2f ? particle.bottom : (nextFloat < 0.8f ? particle.bottom * 0.6f : particle.bottom * 0.3f);
        particle.mag = 4.0f * particle.top / particle.bottom;
        particle.neg = -particle.mag / particle.bottom;
        f = (float)this.mRect.centerX() + Y * (random.nextFloat() - 0.5f);
        particle.cx = particle.baseCx = f + (float)(this.mRect.width() / 2);
        particle.baseCy = f = (float)this.mRect.centerY() + Y * (random.nextFloat() - 0.5f);
        particle.cy = f;
        particle.life = 0.14f * random.nextFloat();
        particle.overflow = 0.4f * random.nextFloat();
        particle.alpha = 1.0f;
        return particle;
    }

    public void draw(Canvas canvas) {
        if (!this.isStarted()) {
            return;
        }
        for (Particle particle : this.mParticles) {
            particle.advance(((Float)this.getAnimatedValue()).floatValue());
            if (!(particle.alpha > 0.0f)) continue;
            this.mPaint.setColor(particle.color);
            this.mPaint.setAlpha((int)((float)Color.alpha((int)particle.color) * particle.alpha));
            canvas.drawCircle(particle.cx, particle.cy, particle.radius, this.mPaint);
        }
        this.postInvalidate();
    }

    public void start() {
        super.start();
        this.postInvalidate();
    }

    private void postInvalidate() {
        this.mDragBadgeView.postInvalidate(this.mInvalidateRect.left, this.mInvalidateRect.top, this.mInvalidateRect.right, this.mInvalidateRect.bottom);
    }

    private class Particle {
        float alpha;
        int color;
        float cx;
        float cy;
        float radius;
        float baseCx;
        float baseCy;
        float baseRadius;
        float top;
        float bottom;
        float mag;
        float neg;
        float life;
        float overflow;

        private Particle() {
        }

        public void advance(float factor) {
            float f = 0.0f;
            float normalization = factor / 1.4f;
            if (normalization < this.life || normalization > 1.0f - this.overflow) {
                this.alpha = 0.0f;
                return;
            }
            normalization = (normalization - this.life) / (1.0f - this.life - this.overflow);
            float f2 = normalization * 1.4f;
            if (normalization >= 0.7f) {
                f = (normalization - 0.7f) / 0.3f;
            }
            this.alpha = 1.0f - f;
            f = this.bottom * f2;
            this.cx = this.baseCx + f;
            this.cy = (float)((double)this.baseCy - (double)this.neg * Math.pow(f, 2.0)) - f * this.mag;
            this.radius = V + (this.baseRadius - V) * f2;
        }
    }
}

