/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.badgeview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import cn.bingoogolapple.badgeview.BGADragBadgeView;

public class BGABadgeViewUtil {
    private BGABadgeViewUtil() {
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static Bitmap createBitmapSafely(BGADragBadgeView dragBadgeView, Rect rect, int retryCount) {
        try {
            dragBadgeView.setDrawingCacheEnabled(true);
            return Bitmap.createBitmap((Bitmap)dragBadgeView.getDrawingCache(), (int)(rect.left < 0 ? 0 : rect.left), (int)(rect.top < 0 ? 0 : rect.top), (int)rect.width(), (int)rect.height());
        }
        catch (OutOfMemoryError e) {
            if (retryCount > 0) {
                System.gc();
                return BGABadgeViewUtil.createBitmapSafely(dragBadgeView, rect, retryCount - 1);
            }
            return null;
        }
    }

    public static float getDistanceBetween2Points(PointF p0, PointF p1) {
        float distance = (float)Math.sqrt(Math.pow(p0.y - p1.y, 2.0) + Math.pow(p0.x - p1.x, 2.0));
        return distance;
    }

    public static PointF getMiddlePoint(PointF p1, PointF p2) {
        return new PointF((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f);
    }

    public static PointF getPointByPercent(PointF p1, PointF p2, float percent) {
        return new PointF(BGABadgeViewUtil.evaluate(percent, Float.valueOf(p1.x), Float.valueOf(p2.x)).floatValue(), BGABadgeViewUtil.evaluate(percent, Float.valueOf(p1.y), Float.valueOf(p2.y)).floatValue());
    }

    public static Float evaluate(float fraction, Number startValue, Number endValue) {
        float startFloat = startValue.floatValue();
        return Float.valueOf(startFloat + fraction * (endValue.floatValue() - startFloat));
    }

    public static PointF[] getIntersectionPoints(PointF pMiddle, float radius, Double lineK) {
        PointF[] points = new PointF[2];
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        if (lineK != null) {
            float radian = (float)Math.atan(lineK);
            xOffset = (float)(Math.sin(radian) * (double)radius);
            yOffset = (float)(Math.cos(radian) * (double)radius);
        } else {
            xOffset = radius;
            yOffset = 0.0f;
        }
        points[0] = new PointF(pMiddle.x + xOffset, pMiddle.y - yOffset);
        points[1] = new PointF(pMiddle.x - xOffset, pMiddle.y + yOffset);
        return points;
    }
}

