/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.badgeview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import cn.bingoogolapple.badgeview.BGABadgeViewUtil;
import cn.bingoogolapple.badgeview.BGABadgeable;
import cn.bingoogolapple.badgeview.BGADragBadgeView;
import cn.bingoogolapple.badgeview.BGADragDismissDelegate;
import cn.bingoogolapple.badgeview.R;

public class BGABadgeViewHelper {
    private Bitmap mBitmap;
    private BGABadgeable mBadgeable;
    private Paint mBadgePaint;
    private int mBadgeBgColor;
    private int mBadgeTextColor;
    private int mBadgeTextSize;
    private int mBadgeVerticalMargin;
    private int mBadgeHorizontalMargin;
    private int mBadgePadding;
    private String mBadgeText;
    private Rect mBadgeNumberRect;
    private boolean mIsShowBadge;
    private BadgeGravity mBadgeGravity;
    private RectF mBadgeRectF;
    private boolean mDraggable;
    private boolean mIsResumeTravel;
    private int mBadgeBorderWidth;
    private int mBadgeBorderColor;
    private int mDragExtra;
    private RectF mBadgeDragExtraRectF;
    private BGADragBadgeView mDropBadgeView;
    private boolean mIsDragging;
    private BGADragDismissDelegate mDelegate;
    private boolean mIsShowDrawable = false;

    public BGABadgeViewHelper(BGABadgeable badgeable, Context context, AttributeSet attrs, BadgeGravity defaultBadgeGravity) {
        this.mBadgeable = badgeable;
        this.initDefaultAttrs(context, defaultBadgeGravity);
        this.initCustomAttrs(context, attrs);
        this.afterInitDefaultAndCustomAttrs();
        this.mDropBadgeView = new BGADragBadgeView(context, this);
    }

    private void initDefaultAttrs(Context context, BadgeGravity defaultBadgeGravity) {
        this.mBadgeNumberRect = new Rect();
        this.mBadgeRectF = new RectF();
        this.mBadgeBgColor = -65536;
        this.mBadgeTextColor = -1;
        this.mBadgeTextSize = BGABadgeViewUtil.sp2px(context, 10.0f);
        this.mBadgePaint = new Paint();
        this.mBadgePaint.setAntiAlias(true);
        this.mBadgePaint.setStyle(Paint.Style.FILL);
        this.mBadgePaint.setTextAlign(Paint.Align.CENTER);
        this.mBadgePadding = BGABadgeViewUtil.dp2px(context, 4.0f);
        this.mBadgeVerticalMargin = BGABadgeViewUtil.dp2px(context, 4.0f);
        this.mBadgeHorizontalMargin = BGABadgeViewUtil.dp2px(context, 4.0f);
        this.mBadgeGravity = defaultBadgeGravity;
        this.mIsShowBadge = false;
        this.mBadgeText = null;
        this.mBitmap = null;
        this.mIsDragging = false;
        this.mDraggable = false;
        this.mBadgeBorderColor = -1;
        this.mDragExtra = BGABadgeViewUtil.dp2px(context, 4.0f);
        this.mBadgeDragExtraRectF = new RectF();
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGABadgeView);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.BGABadgeView_badge_bgColor) {
            this.mBadgeBgColor = typedArray.getColor(attr, this.mBadgeBgColor);
        } else if (attr == R.styleable.BGABadgeView_badge_textColor) {
            this.mBadgeTextColor = typedArray.getColor(attr, this.mBadgeTextColor);
        } else if (attr == R.styleable.BGABadgeView_badge_textSize) {
            this.mBadgeTextSize = typedArray.getDimensionPixelSize(attr, this.mBadgeTextSize);
        } else if (attr == R.styleable.BGABadgeView_badge_verticalMargin) {
            this.mBadgeVerticalMargin = typedArray.getDimensionPixelSize(attr, this.mBadgeVerticalMargin);
        } else if (attr == R.styleable.BGABadgeView_badge_horizontalMargin) {
            this.mBadgeHorizontalMargin = typedArray.getDimensionPixelSize(attr, this.mBadgeHorizontalMargin);
        } else if (attr == R.styleable.BGABadgeView_badge_padding) {
            this.mBadgePadding = typedArray.getDimensionPixelSize(attr, this.mBadgePadding);
        } else if (attr == R.styleable.BGABadgeView_badge_gravity) {
            int ordinal = typedArray.getInt(attr, this.mBadgeGravity.ordinal());
            this.mBadgeGravity = BadgeGravity.values()[ordinal];
        } else if (attr == R.styleable.BGABadgeView_badge_draggable) {
            this.mDraggable = typedArray.getBoolean(attr, this.mDraggable);
        } else if (attr == R.styleable.BGABadgeView_badge_isResumeTravel) {
            this.mIsResumeTravel = typedArray.getBoolean(attr, this.mIsResumeTravel);
        } else if (attr == R.styleable.BGABadgeView_badge_borderWidth) {
            this.mBadgeBorderWidth = typedArray.getDimensionPixelSize(attr, this.mBadgeBorderWidth);
        } else if (attr == R.styleable.BGABadgeView_badge_borderColor) {
            this.mBadgeBorderColor = typedArray.getColor(attr, this.mBadgeBorderColor);
        } else if (attr == R.styleable.BGABadgeView_badge_dragExtra) {
            this.mDragExtra = typedArray.getDimensionPixelSize(attr, this.mDragExtra);
        }
    }

    private void afterInitDefaultAndCustomAttrs() {
        this.mBadgePaint.setTextSize((float)this.mBadgeTextSize);
    }

    public void setBadgeBgColorInt(int badgeBgColor) {
        this.mBadgeBgColor = badgeBgColor;
        this.mBadgeable.postInvalidate();
    }

    public void setBadgeTextColorInt(int badgeTextColor) {
        this.mBadgeTextColor = badgeTextColor;
        this.mBadgeable.postInvalidate();
    }

    public void setBadgeTextSizeSp(int badgetextSize) {
        if (badgetextSize >= 0) {
            this.mBadgeTextSize = BGABadgeViewUtil.sp2px(this.mBadgeable.getContext(), badgetextSize);
            this.mBadgePaint.setTextSize((float)this.mBadgeTextSize);
            this.mBadgeable.postInvalidate();
        }
    }

    public void setBadgeVerticalMarginDp(int badgeVerticalMargin) {
        if (badgeVerticalMargin >= 0) {
            this.mBadgeVerticalMargin = BGABadgeViewUtil.dp2px(this.mBadgeable.getContext(), badgeVerticalMargin);
            this.mBadgeable.postInvalidate();
        }
    }

    public void setBadgeHorizontalMarginDp(int badgeHorizontalMargin) {
        if (badgeHorizontalMargin >= 0) {
            this.mBadgeHorizontalMargin = BGABadgeViewUtil.dp2px(this.mBadgeable.getContext(), badgeHorizontalMargin);
            this.mBadgeable.postInvalidate();
        }
    }

    public void setBadgePaddingDp(int badgePadding) {
        if (badgePadding >= 0) {
            this.mBadgePadding = BGABadgeViewUtil.dp2px(this.mBadgeable.getContext(), badgePadding);
            this.mBadgeable.postInvalidate();
        }
    }

    public void setBadgeGravity(BadgeGravity badgeGravity) {
        if (badgeGravity != null) {
            this.mBadgeGravity = badgeGravity;
            this.mBadgeable.postInvalidate();
        }
    }

    public void setDraggable(boolean draggable) {
        this.mDraggable = draggable;
        this.mBadgeable.postInvalidate();
    }

    public void setIsResumeTravel(boolean isResumeTravel) {
        this.mIsResumeTravel = isResumeTravel;
        this.mBadgeable.postInvalidate();
    }

    public void setBadgeBorderWidthDp(int badgeBorderWidthDp) {
        if (badgeBorderWidthDp >= 0) {
            this.mBadgeBorderWidth = BGABadgeViewUtil.dp2px(this.mBadgeable.getContext(), badgeBorderWidthDp);
            this.mBadgeable.postInvalidate();
        }
    }

    public void setBadgeBorderColorInt(int badgeBorderColor) {
        this.mBadgeBorderColor = badgeBorderColor;
        this.mBadgeable.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mBadgeDragExtraRectF.left = this.mBadgeRectF.left - (float)this.mDragExtra;
                this.mBadgeDragExtraRectF.top = this.mBadgeRectF.top - (float)this.mDragExtra;
                this.mBadgeDragExtraRectF.right = this.mBadgeRectF.right + (float)this.mDragExtra;
                this.mBadgeDragExtraRectF.bottom = this.mBadgeRectF.bottom + (float)this.mDragExtra;
                if (this.mBadgeBorderWidth != 0 && !this.mIsShowDrawable || !this.mDraggable || !this.mIsShowBadge || !this.mBadgeDragExtraRectF.contains(event.getX(), event.getY())) break;
                this.mIsDragging = true;
                this.mBadgeable.getParent().requestDisallowInterceptTouchEvent(true);
                Rect badgeableRect = new Rect();
                this.mBadgeable.getGlobalVisibleRect(badgeableRect);
                this.mDropBadgeView.setStickCenter((float)badgeableRect.left + this.mBadgeRectF.left + this.mBadgeRectF.width() / 2.0f, (float)badgeableRect.top + this.mBadgeRectF.top + this.mBadgeRectF.height() / 2.0f);
                this.mDropBadgeView.onTouchEvent(event);
                this.mBadgeable.postInvalidate();
                return true;
            }
            case 2: {
                if (!this.mIsDragging) break;
                this.mDropBadgeView.onTouchEvent(event);
                return true;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) break;
                this.mDropBadgeView.onTouchEvent(event);
                this.mIsDragging = false;
                return true;
            }
        }
        return this.mBadgeable.callSuperOnTouchEvent(event);
    }

    public void endDragWithDismiss() {
        this.hiddenBadge();
        if (this.mDelegate != null) {
            this.mDelegate.onDismiss(this.mBadgeable);
        }
    }

    public void endDragWithoutDismiss() {
        this.mBadgeable.postInvalidate();
    }

    public void drawBadge(Canvas canvas) {
        if (this.mIsShowBadge && !this.mIsDragging) {
            if (this.mIsShowDrawable) {
                this.drawDrawableBadge(canvas);
            } else {
                this.drawTextBadge(canvas);
            }
        }
    }

    private void drawDrawableBadge(Canvas canvas) {
        this.mBadgeRectF.left = this.mBadgeable.getWidth() - this.mBadgeHorizontalMargin - this.mBitmap.getWidth();
        this.mBadgeRectF.top = this.mBadgeVerticalMargin;
        switch (this.mBadgeGravity) {
            case RightTop: {
                this.mBadgeRectF.top = this.mBadgeVerticalMargin;
                break;
            }
            case RightCenter: {
                this.mBadgeRectF.top = (this.mBadgeable.getHeight() - this.mBitmap.getHeight()) / 2;
                break;
            }
            case RightBottom: {
                this.mBadgeRectF.top = this.mBadgeable.getHeight() - this.mBitmap.getHeight() - this.mBadgeVerticalMargin;
                break;
            }
        }
        canvas.drawBitmap(this.mBitmap, this.mBadgeRectF.left, this.mBadgeRectF.top, this.mBadgePaint);
        this.mBadgeRectF.right = this.mBadgeRectF.left + (float)this.mBitmap.getWidth();
        this.mBadgeRectF.bottom = this.mBadgeRectF.top + (float)this.mBitmap.getHeight();
    }

    private void drawTextBadge(Canvas canvas) {
        String badgeText = "";
        if (!TextUtils.isEmpty((CharSequence)this.mBadgeText)) {
            badgeText = this.mBadgeText;
        }
        this.mBadgePaint.getTextBounds(badgeText, 0, badgeText.length(), this.mBadgeNumberRect);
        int badgeHeight = this.mBadgeNumberRect.height() + this.mBadgePadding * 2;
        int badgeWidth = badgeText.length() == 1 || badgeText.length() == 0 ? badgeHeight : this.mBadgeNumberRect.width() + this.mBadgePadding * 2;
        this.mBadgeRectF.top = this.mBadgeVerticalMargin;
        this.mBadgeRectF.bottom = this.mBadgeable.getHeight() - this.mBadgeVerticalMargin;
        switch (this.mBadgeGravity) {
            case RightTop: {
                this.mBadgeRectF.bottom = this.mBadgeRectF.top + (float)badgeHeight;
                break;
            }
            case RightCenter: {
                this.mBadgeRectF.top = (this.mBadgeable.getHeight() - badgeHeight) / 2;
                this.mBadgeRectF.bottom = this.mBadgeRectF.top + (float)badgeHeight;
                break;
            }
            case RightBottom: {
                this.mBadgeRectF.top = this.mBadgeRectF.bottom - (float)badgeHeight;
                break;
            }
        }
        this.mBadgeRectF.right = this.mBadgeable.getWidth() - this.mBadgeHorizontalMargin;
        this.mBadgeRectF.left = this.mBadgeRectF.right - (float)badgeWidth;
        if (this.mBadgeBorderWidth > 0) {
            this.mBadgePaint.setColor(this.mBadgeBorderColor);
            canvas.drawRoundRect(this.mBadgeRectF, (float)(badgeHeight / 2), (float)(badgeHeight / 2), this.mBadgePaint);
            this.mBadgePaint.setColor(this.mBadgeBgColor);
            canvas.drawRoundRect(new RectF(this.mBadgeRectF.left + (float)this.mBadgeBorderWidth, this.mBadgeRectF.top + (float)this.mBadgeBorderWidth, this.mBadgeRectF.right - (float)this.mBadgeBorderWidth, this.mBadgeRectF.bottom - (float)this.mBadgeBorderWidth), (float)((badgeHeight - 2 * this.mBadgeBorderWidth) / 2), (float)((badgeHeight - 2 * this.mBadgeBorderWidth) / 2), this.mBadgePaint);
        } else {
            this.mBadgePaint.setColor(this.mBadgeBgColor);
            canvas.drawRoundRect(this.mBadgeRectF, (float)(badgeHeight / 2), (float)(badgeHeight / 2), this.mBadgePaint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBadgeText)) {
            this.mBadgePaint.setColor(this.mBadgeTextColor);
            float x = this.mBadgeRectF.left + (float)(badgeWidth / 2);
            float y = this.mBadgeRectF.bottom - (float)this.mBadgePadding;
            canvas.drawText(badgeText, x, y, this.mBadgePaint);
        }
    }

    public void showCirclePointBadge() {
        this.showTextBadge(null);
    }

    public void showTextBadge(String badgeText) {
        this.mIsShowDrawable = false;
        this.mBadgeText = badgeText;
        this.mIsShowBadge = true;
        this.mBadgeable.postInvalidate();
    }

    public void hiddenBadge() {
        this.mIsShowBadge = false;
        this.mBadgeable.postInvalidate();
    }

    public boolean isShowBadge() {
        return this.mIsShowBadge;
    }

    public void showDrawable(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mIsShowDrawable = true;
        this.mIsShowBadge = true;
        this.mBadgeable.postInvalidate();
    }

    public boolean isShowDrawable() {
        return this.mIsShowDrawable;
    }

    public RectF getBadgeRectF() {
        return this.mBadgeRectF;
    }

    public int getBadgePadding() {
        return this.mBadgePadding;
    }

    public String getBadgeText() {
        return this.mBadgeText;
    }

    public int getBadgeBgColor() {
        return this.mBadgeBgColor;
    }

    public int getBadgeTextColor() {
        return this.mBadgeTextColor;
    }

    public int getBadgeTextSize() {
        return this.mBadgeTextSize;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setDragDismissDelegate(BGADragDismissDelegate delegate) {
        this.mDelegate = delegate;
    }

    public View getRootView() {
        return this.mBadgeable.getRootView();
    }

    public boolean isResumeTravel() {
        return this.mIsResumeTravel;
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean isDraggable() {
        return this.mDraggable;
    }

    public static enum BadgeGravity {
        RightTop,
        RightCenter,
        RightBottom;

    }
}

