/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.notify;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;

@XStreamAlias(value="xml")
public class WxPayNotifyResponse {
    @XStreamOmitField
    private static final transient String FAIL = "FAIL";
    @XStreamOmitField
    private static final transient String SUCCESS = "SUCCESS";
    @XStreamAlias(value="return_code")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String returnCode;
    @XStreamConverter(value=XStreamCDataConverter.class)
    @XStreamAlias(value="return_msg")
    private String returnMsg;

    public static String fail(String msg) {
        WxPayNotifyResponse response = new WxPayNotifyResponse(FAIL, msg);
        XStream xstream = XStreamInitializer.getInstance();
        xstream.autodetectAnnotations(true);
        return xstream.toXML((Object)response);
    }

    public static String success(String msg) {
        WxPayNotifyResponse response = new WxPayNotifyResponse(SUCCESS, msg);
        XStream xstream = XStreamInitializer.getInstance();
        xstream.autodetectAnnotations(true);
        return xstream.toXML((Object)response);
    }

    public static WxPayNotifyResponseBuilder newBuilder() {
        return new WxPayNotifyResponseBuilder();
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getReturnMsg() {
        return this.returnMsg;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayNotifyResponse)) {
            return false;
        }
        WxPayNotifyResponse other = (WxPayNotifyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$returnCode = this.getReturnCode();
        String other$returnCode = other.getReturnCode();
        if (this$returnCode == null ? other$returnCode != null : !this$returnCode.equals(other$returnCode)) {
            return false;
        }
        String this$returnMsg = this.getReturnMsg();
        String other$returnMsg = other.getReturnMsg();
        return !(this$returnMsg == null ? other$returnMsg != null : !this$returnMsg.equals(other$returnMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayNotifyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $returnCode = this.getReturnCode();
        result = result * 59 + ($returnCode == null ? 43 : $returnCode.hashCode());
        String $returnMsg = this.getReturnMsg();
        result = result * 59 + ($returnMsg == null ? 43 : $returnMsg.hashCode());
        return result;
    }

    public String toString() {
        return "WxPayNotifyResponse(returnCode=" + this.getReturnCode() + ", returnMsg=" + this.getReturnMsg() + ")";
    }

    public WxPayNotifyResponse() {
    }

    public WxPayNotifyResponse(String returnCode, String returnMsg) {
        this.returnCode = returnCode;
        this.returnMsg = returnMsg;
    }

    public static class WxPayNotifyResponseBuilder {
        private String returnCode;
        private String returnMsg;

        WxPayNotifyResponseBuilder() {
        }

        public WxPayNotifyResponseBuilder returnCode(String returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public WxPayNotifyResponseBuilder returnMsg(String returnMsg) {
            this.returnMsg = returnMsg;
            return this;
        }

        public WxPayNotifyResponse build() {
            return new WxPayNotifyResponse(this.returnCode, this.returnMsg);
        }

        public String toString() {
            return "WxPayNotifyResponse.WxPayNotifyResponseBuilder(returnCode=" + this.returnCode + ", returnMsg=" + this.returnMsg + ")";
        }
    }
}

