/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    @Deprecated
    public static String createSign(Object xmlBean, String signKey) {
        return SignUtils.createSign(SignUtils.xmlBean2Map(xmlBean), signKey);
    }

    @Deprecated
    public static String createSign(Map<String, String> params, String signKey) {
        return SignUtils.createSign(params, null, signKey, new String[0]);
    }

    public static String createSign(Object xmlBean, String signType, String signKey, String[] ignoredParams) {
        return SignUtils.createSign(SignUtils.xmlBean2Map(xmlBean), signType, signKey, ignoredParams);
    }

    public static String createSign(Map<String, String> params, String signType, String signKey, String[] ignoredParams) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        StringBuilder toSign = new StringBuilder();
        for (String key : sortedMap.keySet()) {
            String value = params.get(key);
            boolean shouldSign = false;
            if (StringUtils.isNotEmpty((CharSequence)value) && !ArrayUtils.contains((Object[])ignoredParams, (Object)key) && !Lists.newArrayList((Object[])new String[]{"sign", "key", "xmlString", "xmlDoc", "couponList"}).contains(key)) {
                shouldSign = true;
            }
            if (!shouldSign) continue;
            toSign.append(key).append("=").append(value).append("&");
        }
        toSign.append("key=").append(signKey);
        if ("HMAC-SHA256".equals(signType)) {
            return me.chanjar.weixin.common.util.SignUtils.createHmacSha256Sign((String)toSign.toString(), (String)signKey);
        }
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    public static boolean checkSign(Object xmlBean, String signType, String signKey) {
        return SignUtils.checkSign(SignUtils.xmlBean2Map(xmlBean), signType, signKey);
    }

    public static boolean checkSign(Map<String, String> params, String signType, String signKey) {
        String sign = SignUtils.createSign(params, signType, signKey, new String[0]);
        return sign.equals(params.get("sign"));
    }

    public static Map<String, String> xmlBean2Map(Object bean) {
        HashMap result = Maps.newHashMap();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        if (bean.getClass().getSuperclass().getSuperclass() == BaseWxPayRequest.class) {
            fields.addAll(Arrays.asList(BaseWxPayRequest.class.getDeclaredFields()));
        }
        if (bean.getClass().getSuperclass().getSuperclass() == BaseWxPayResult.class) {
            fields.addAll(Arrays.asList(BaseWxPayResult.class.getDeclaredFields()));
        }
        for (Field field : fields) {
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.get(bean) == null) {
                    field.setAccessible(isAccessible);
                    continue;
                }
                if (field.isAnnotationPresent(XStreamAlias.class)) {
                    result.put(field.getAnnotation(XStreamAlias.class).value(), field.get(bean).toString());
                } else if (!Modifier.isStatic(field.getModifiers())) {
                    result.put(field.getName(), field.get(bean).toString());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

