/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayDownloadBillRequest
extends BaseWxPayRequest {
    private static final String[] BILL_TYPES = new String[]{"ALL", "SUCCESS", "REFUND", "RECHARGE_REFUND"};
    private static final String TAR_TYPE_GZIP = "GZIP";
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @Required
    @XStreamAlias(value="bill_type")
    private String billType;
    @Required
    @XStreamAlias(value="bill_date")
    private String billDate;
    @XStreamAlias(value="tar_type")
    private String tarType;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getTarType()) && !TAR_TYPE_GZIP.equals(this.getTarType())) {
            throw new WxPayException("tar_type\u503c\u5982\u679c\u5b58\u5728\uff0c\u53ea\u80fd\u4e3aGZIP");
        }
        if (!ArrayUtils.contains((Object[])BILL_TYPES, (Object)this.getBillType())) {
            throw new WxPayException(String.format("bill_type\u76ee\u524d\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(BILL_TYPES), this.getBillType()));
        }
    }

    public static WxPayDownloadBillRequestBuilder newBuilder() {
        return new WxPayDownloadBillRequestBuilder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getBillType() {
        return this.billType;
    }

    public String getBillDate() {
        return this.billDate;
    }

    public String getTarType() {
        return this.tarType;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public void setBillDate(String billDate) {
        this.billDate = billDate;
    }

    public void setTarType(String tarType) {
        this.tarType = tarType;
    }

    @Override
    public String toString() {
        return "WxPayDownloadBillRequest(deviceInfo=" + this.getDeviceInfo() + ", billType=" + this.getBillType() + ", billDate=" + this.getBillDate() + ", tarType=" + this.getTarType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayDownloadBillRequest)) {
            return false;
        }
        WxPayDownloadBillRequest other = (WxPayDownloadBillRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$billType = this.getBillType();
        String other$billType = other.getBillType();
        if (this$billType == null ? other$billType != null : !this$billType.equals(other$billType)) {
            return false;
        }
        String this$billDate = this.getBillDate();
        String other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !this$billDate.equals(other$billDate)) {
            return false;
        }
        String this$tarType = this.getTarType();
        String other$tarType = other.getTarType();
        return !(this$tarType == null ? other$tarType != null : !this$tarType.equals(other$tarType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayDownloadBillRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $billType = this.getBillType();
        result = result * 59 + ($billType == null ? 43 : $billType.hashCode());
        String $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : $billDate.hashCode());
        String $tarType = this.getTarType();
        result = result * 59 + ($tarType == null ? 43 : $tarType.hashCode());
        return result;
    }

    public WxPayDownloadBillRequest() {
    }

    @ConstructorProperties(value={"deviceInfo", "billType", "billDate", "tarType"})
    public WxPayDownloadBillRequest(String deviceInfo, String billType, String billDate, String tarType) {
        this.deviceInfo = deviceInfo;
        this.billType = billType;
        this.billDate = billDate;
        this.tarType = tarType;
    }

    public static class WxPayDownloadBillRequestBuilder {
        private String deviceInfo;
        private String billType;
        private String billDate;
        private String tarType;

        WxPayDownloadBillRequestBuilder() {
        }

        public WxPayDownloadBillRequestBuilder deviceInfo(String deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public WxPayDownloadBillRequestBuilder billType(String billType) {
            this.billType = billType;
            return this;
        }

        public WxPayDownloadBillRequestBuilder billDate(String billDate) {
            this.billDate = billDate;
            return this;
        }

        public WxPayDownloadBillRequestBuilder tarType(String tarType) {
            this.tarType = tarType;
            return this;
        }

        public WxPayDownloadBillRequest build() {
            return new WxPayDownloadBillRequest(this.deviceInfo, this.billType, this.billDate, this.tarType);
        }

        public String toString() {
            return "WxPayDownloadBillRequest.WxPayDownloadBillRequestBuilder(deviceInfo=" + this.deviceInfo + ", billType=" + this.billType + ", billDate=" + this.billDate + ", tarType=" + this.tarType + ")";
        }
    }
}

