/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.notify;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@XStreamAlias(value="xml")
public class WxPayRefundNotifyResult
extends BaseWxPayResult
implements Serializable {
    private static final long serialVersionUID = 4651725860079259186L;
    @XStreamAlias(value="req_info")
    private String reqInfoString;
    private ReqInfo reqInfo;

    public static WxPayRefundNotifyResult fromXML(String xmlString, String mchKey) throws WxPayException {
        WxPayRefundNotifyResult result = BaseWxPayResult.fromXML(xmlString, WxPayRefundNotifyResult.class);
        String reqInfoString = result.getReqInfoString();
        try {
            String keyMd5String = DigestUtils.md5Hex((String)mchKey).toLowerCase();
            SecretKeySpec key = new SecretKeySpec(keyMd5String.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key);
            result.setReqInfo(ReqInfo.fromXML(new String(cipher.doFinal(Base64.decodeBase64((String)reqInfoString)))));
        }
        catch (Exception e) {
            throw new WxPayException("\u89e3\u5bc6\u9000\u6b3e\u901a\u77e5\u52a0\u5bc6\u4fe1\u606f\u65f6\u51fa\u9519", e);
        }
        return result;
    }

    public String getReqInfoString() {
        return this.reqInfoString;
    }

    public ReqInfo getReqInfo() {
        return this.reqInfo;
    }

    public void setReqInfoString(String reqInfoString) {
        this.reqInfoString = reqInfoString;
    }

    public void setReqInfo(ReqInfo reqInfo) {
        this.reqInfo = reqInfo;
    }

    @Override
    public String toString() {
        return "WxPayRefundNotifyResult(reqInfoString=" + this.getReqInfoString() + ", reqInfo=" + this.getReqInfo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundNotifyResult)) {
            return false;
        }
        WxPayRefundNotifyResult other = (WxPayRefundNotifyResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$reqInfoString = this.getReqInfoString();
        String other$reqInfoString = other.getReqInfoString();
        if (this$reqInfoString == null ? other$reqInfoString != null : !this$reqInfoString.equals(other$reqInfoString)) {
            return false;
        }
        ReqInfo this$reqInfo = this.getReqInfo();
        ReqInfo other$reqInfo = other.getReqInfo();
        return !(this$reqInfo == null ? other$reqInfo != null : !((Object)this$reqInfo).equals(other$reqInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundNotifyResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $reqInfoString = this.getReqInfoString();
        result = result * 59 + ($reqInfoString == null ? 43 : $reqInfoString.hashCode());
        ReqInfo $reqInfo = this.getReqInfo();
        result = result * 59 + ($reqInfo == null ? 43 : ((Object)$reqInfo).hashCode());
        return result;
    }

    public WxPayRefundNotifyResult() {
    }

    @ConstructorProperties(value={"reqInfoString", "reqInfo"})
    public WxPayRefundNotifyResult(String reqInfoString, ReqInfo reqInfo) {
        this.reqInfoString = reqInfoString;
        this.reqInfo = reqInfo;
    }

    @XStreamAlias(value="root")
    public static class ReqInfo {
        @XStreamAlias(value="transaction_id")
        private String transactionId;
        @XStreamAlias(value="out_trade_no")
        private String outTradeNo;
        @XStreamAlias(value="refund_id")
        private String refundId;
        @XStreamAlias(value="out_refund_no")
        private String outRefundNo;
        @XStreamAlias(value="total_fee")
        private Integer totalFee;
        @XStreamAlias(value="settlement_total_fee")
        private Integer settlementTotalFee;
        @XStreamAlias(value="refund_fee")
        private Integer refundFee;
        @XStreamAlias(value="settlement_refund_fee")
        private Integer settlementRefundFee;
        @XStreamAlias(value="refund_status")
        private String refundStatus;
        @XStreamAlias(value="success_time")
        private String successTime;
        @XStreamAlias(value="refund_recv_accout")
        private String refundRecvAccout;
        @XStreamAlias(value="refund_account")
        private String refundAccount;
        @XStreamAlias(value="refund_request_source")
        private String refundRequestSource;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
        }

        public static ReqInfo fromXML(String xmlString) {
            XStream xstream = XStreamInitializer.getInstance();
            xstream.processAnnotations(ReqInfo.class);
            return (ReqInfo)xstream.fromXML(xmlString);
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public String getOutTradeNo() {
            return this.outTradeNo;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public String getOutRefundNo() {
            return this.outRefundNo;
        }

        public Integer getTotalFee() {
            return this.totalFee;
        }

        public Integer getSettlementTotalFee() {
            return this.settlementTotalFee;
        }

        public Integer getRefundFee() {
            return this.refundFee;
        }

        public Integer getSettlementRefundFee() {
            return this.settlementRefundFee;
        }

        public String getRefundStatus() {
            return this.refundStatus;
        }

        public String getSuccessTime() {
            return this.successTime;
        }

        public String getRefundRecvAccout() {
            return this.refundRecvAccout;
        }

        public String getRefundAccount() {
            return this.refundAccount;
        }

        public String getRefundRequestSource() {
            return this.refundRequestSource;
        }

        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public void setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }

        public void setOutRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
        }

        public void setTotalFee(Integer totalFee) {
            this.totalFee = totalFee;
        }

        public void setSettlementTotalFee(Integer settlementTotalFee) {
            this.settlementTotalFee = settlementTotalFee;
        }

        public void setRefundFee(Integer refundFee) {
            this.refundFee = refundFee;
        }

        public void setSettlementRefundFee(Integer settlementRefundFee) {
            this.settlementRefundFee = settlementRefundFee;
        }

        public void setRefundStatus(String refundStatus) {
            this.refundStatus = refundStatus;
        }

        public void setSuccessTime(String successTime) {
            this.successTime = successTime;
        }

        public void setRefundRecvAccout(String refundRecvAccout) {
            this.refundRecvAccout = refundRecvAccout;
        }

        public void setRefundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
        }

        public void setRefundRequestSource(String refundRequestSource) {
            this.refundRequestSource = refundRequestSource;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReqInfo)) {
                return false;
            }
            ReqInfo other = (ReqInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$transactionId = this.getTransactionId();
            String other$transactionId = other.getTransactionId();
            if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
                return false;
            }
            String this$outTradeNo = this.getOutTradeNo();
            String other$outTradeNo = other.getOutTradeNo();
            if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
                return false;
            }
            String this$refundId = this.getRefundId();
            String other$refundId = other.getRefundId();
            if (this$refundId == null ? other$refundId != null : !this$refundId.equals(other$refundId)) {
                return false;
            }
            String this$outRefundNo = this.getOutRefundNo();
            String other$outRefundNo = other.getOutRefundNo();
            if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
                return false;
            }
            Integer this$totalFee = this.getTotalFee();
            Integer other$totalFee = other.getTotalFee();
            if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
                return false;
            }
            Integer this$settlementTotalFee = this.getSettlementTotalFee();
            Integer other$settlementTotalFee = other.getSettlementTotalFee();
            if (this$settlementTotalFee == null ? other$settlementTotalFee != null : !((Object)this$settlementTotalFee).equals(other$settlementTotalFee)) {
                return false;
            }
            Integer this$refundFee = this.getRefundFee();
            Integer other$refundFee = other.getRefundFee();
            if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
                return false;
            }
            Integer this$settlementRefundFee = this.getSettlementRefundFee();
            Integer other$settlementRefundFee = other.getSettlementRefundFee();
            if (this$settlementRefundFee == null ? other$settlementRefundFee != null : !((Object)this$settlementRefundFee).equals(other$settlementRefundFee)) {
                return false;
            }
            String this$refundStatus = this.getRefundStatus();
            String other$refundStatus = other.getRefundStatus();
            if (this$refundStatus == null ? other$refundStatus != null : !this$refundStatus.equals(other$refundStatus)) {
                return false;
            }
            String this$successTime = this.getSuccessTime();
            String other$successTime = other.getSuccessTime();
            if (this$successTime == null ? other$successTime != null : !this$successTime.equals(other$successTime)) {
                return false;
            }
            String this$refundRecvAccout = this.getRefundRecvAccout();
            String other$refundRecvAccout = other.getRefundRecvAccout();
            if (this$refundRecvAccout == null ? other$refundRecvAccout != null : !this$refundRecvAccout.equals(other$refundRecvAccout)) {
                return false;
            }
            String this$refundAccount = this.getRefundAccount();
            String other$refundAccount = other.getRefundAccount();
            if (this$refundAccount == null ? other$refundAccount != null : !this$refundAccount.equals(other$refundAccount)) {
                return false;
            }
            String this$refundRequestSource = this.getRefundRequestSource();
            String other$refundRequestSource = other.getRefundRequestSource();
            return !(this$refundRequestSource == null ? other$refundRequestSource != null : !this$refundRequestSource.equals(other$refundRequestSource));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReqInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $transactionId = this.getTransactionId();
            result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
            String $outTradeNo = this.getOutTradeNo();
            result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
            String $refundId = this.getRefundId();
            result = result * 59 + ($refundId == null ? 43 : $refundId.hashCode());
            String $outRefundNo = this.getOutRefundNo();
            result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
            Integer $totalFee = this.getTotalFee();
            result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
            Integer $settlementTotalFee = this.getSettlementTotalFee();
            result = result * 59 + ($settlementTotalFee == null ? 43 : ((Object)$settlementTotalFee).hashCode());
            Integer $refundFee = this.getRefundFee();
            result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
            Integer $settlementRefundFee = this.getSettlementRefundFee();
            result = result * 59 + ($settlementRefundFee == null ? 43 : ((Object)$settlementRefundFee).hashCode());
            String $refundStatus = this.getRefundStatus();
            result = result * 59 + ($refundStatus == null ? 43 : $refundStatus.hashCode());
            String $successTime = this.getSuccessTime();
            result = result * 59 + ($successTime == null ? 43 : $successTime.hashCode());
            String $refundRecvAccout = this.getRefundRecvAccout();
            result = result * 59 + ($refundRecvAccout == null ? 43 : $refundRecvAccout.hashCode());
            String $refundAccount = this.getRefundAccount();
            result = result * 59 + ($refundAccount == null ? 43 : $refundAccount.hashCode());
            String $refundRequestSource = this.getRefundRequestSource();
            result = result * 59 + ($refundRequestSource == null ? 43 : $refundRequestSource.hashCode());
            return result;
        }
    }
}

