/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.mp.bean.subscribe.WxMpSubscribeMessage;

public class WxMpSubscribeMessageGsonAdapter
implements JsonSerializer<WxMpSubscribeMessage> {
    public JsonElement serialize(WxMpSubscribeMessage message, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("touser", message.getToUser());
        messageJson.addProperty("template_id", message.getTemplateId());
        if (message.getUrl() != null) {
            messageJson.addProperty("url", message.getUrl());
        }
        if (message.getMiniProgram() != null) {
            JsonObject miniProgramJson = new JsonObject();
            miniProgramJson.addProperty("appid", message.getMiniProgram().getAppid());
            miniProgramJson.addProperty("pagepath", message.getMiniProgram().getPagePath());
            messageJson.add("miniprogram", (JsonElement)miniProgramJson);
        }
        messageJson.addProperty("scene", message.getScene());
        messageJson.addProperty("title", message.getTitle());
        JsonObject data = new JsonObject();
        messageJson.add("data", (JsonElement)data);
        JsonObject content = new JsonObject();
        data.add("content", (JsonElement)content);
        if (message.getContentValue() != null) {
            content.addProperty("value", message.getContentValue());
        }
        if (message.getContentColor() != null) {
            content.addProperty("color", message.getContentColor());
        }
        return messageJson;
    }
}

