/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.util.concurrent.locks.Lock;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.JoddHttp;
import jodd.http.ProxyInfo;
import jodd.http.net.SocketHttpConnectionProvider;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;

public class WxMpServiceJoddHttpImpl
extends BaseWxMpServiceImpl<HttpConnectionProvider, ProxyInfo> {
    private HttpConnectionProvider httpClient;
    private ProxyInfo httpProxy;

    public HttpConnectionProvider getRequestHttpClient() {
        return this.httpClient;
    }

    public ProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.JODD_HTTP;
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage configStorage = this.getWxMpConfigStorage();
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new ProxyInfo(ProxyInfo.ProxyType.HTTP, configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort(), configStorage.getHttpProxyUsername(), configStorage.getHttpProxyPassword());
        }
        this.httpClient = JoddHttp.httpConnectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        Lock lock = this.getWxMpConfigStorage().getAccessTokenLock();
        try {
            lock.lock();
            if (this.getWxMpConfigStorage().isAccessTokenExpired() || forceRefresh) {
                HttpResponse response;
                String resultContent;
                WxError error;
                String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
                HttpRequest request = HttpRequest.get((String)url);
                if (this.getRequestHttpProxy() != null) {
                    SocketHttpConnectionProvider provider = new SocketHttpConnectionProvider();
                    provider.useProxy(this.getRequestHttpProxy());
                    request.withConnectionProvider((HttpConnectionProvider)provider);
                }
                if ((error = WxError.fromJson((String)(resultContent = (response = request.send()).bodyText()), (WxType)WxType.MP)).getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.getWxMpConfigStorage().updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
        }
        finally {
            lock.unlock();
        }
        return this.getWxMpConfigStorage().getAccessToken();
    }
}

