/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class WxMpInRedisConfigStorage
extends WxMpInMemoryConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";
    protected final JedisPool jedisPool;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private String cardapiTicketKey;

    public WxMpInRedisConfigStorage(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    @Override
    public String getAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.accessTokenKey);
            return string;
        }
    }

    @Override
    public boolean isAccessTokenExpired() {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.accessTokenKey) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.accessTokenKey, expiresInSeconds - 200, accessToken);
        }
    }

    @Override
    public void expireAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.accessTokenKey, 0);
        }
    }

    @Override
    public String getJsapiTicket() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.jsapiTicketKey);
            return string;
        }
    }

    @Override
    public boolean isJsapiTicketExpired() {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.jsapiTicketKey) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.jsapiTicketKey, expiresInSeconds - 200, jsapiTicket);
        }
    }

    @Override
    public void expireJsapiTicket() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.jsapiTicketKey, 0);
        }
    }

    @Override
    public String getCardApiTicket() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.cardapiTicketKey);
            return string;
        }
    }

    @Override
    public boolean isCardApiTicketExpired() {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.cardapiTicketKey) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.cardapiTicketKey, expiresInSeconds - 200, cardApiTicket);
        }
    }

    @Override
    public void expireCardApiTicket() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.cardapiTicketKey, 0);
        }
    }
}

