/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.vod.WxMaVodSingleFileUploadResult;
import cn.binarywang.wx.miniapp.executor.VodSingleUploadRequestExecutor;
import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpVodSingleUploadRequestExecutor
extends VodSingleUploadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    public OkHttpVodSingleUploadRequestExecutor(RequestHttp requestHttp, String mediaName, String mediaType, String coverType, File coverData, String sourceContext) {
        super(requestHttp, mediaName, mediaType, coverType, coverData, sourceContext);
    }

    public WxMaVodSingleFileUploadResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart("media_data", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
        bodyBuilder.addFormDataPart("media_type", this.mediaType).addFormDataPart("media_name", this.mediaName);
        if (this.coverType != null) {
            bodyBuilder.addFormDataPart("cover_type", this.coverType);
        }
        if (this.coverData != null) {
            bodyBuilder.addFormDataPart("cover_data", this.coverData.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)this.coverData));
        }
        if (this.sourceContext != null) {
            bodyBuilder.addFormDataPart("source_context", this.sourceContext);
        }
        Request request = new Request.Builder().url(uri).post((RequestBody)bodyBuilder.build()).build();
        Response response = ((OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request).execute();
        String responseContent = response.body().string();
        WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMaVodSingleFileUploadResult.fromJson(responseContent);
    }
}

