/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.api.WxImgProcService;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcAiCropResult;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcQrCodeResult;
import me.chanjar.weixin.common.bean.imgproc.WxImgProcSuperResolutionResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.requestexecuter.ocr.OcrDiscernRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.lang3.StringUtils;

public class WxMaImgProcServiceImpl
implements WxImgProcService {
    private static final String QRCODE = "/cv/img/qrcode?img_url=%s";
    private static final String FILE_QRCODE = "/cv/img/qrcode";
    private static final String SUPER_RESOLUTION = "/cv/img/superresolution?img_url=%s";
    private static final String FILE_SUPER_RESOLUTION = "/cv/img/superresolution";
    private static final String AI_CROP = "/cv/img/aicrop?img_url=%s&ratios=%s";
    private static final String FILE_AI_CROP = "/cv/img/aicrop?ratios=%s";
    private final WxMaService service;

    public WxImgProcQrCodeResult qrCode(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.service.get(String.format(QRCODE, imgUrl), null);
        return WxImgProcQrCodeResult.fromJson((String)result);
    }

    public WxImgProcQrCodeResult qrCode(File imgFile) throws WxErrorException {
        String result = (String)this.service.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.service.getRequestHttp()), FILE_QRCODE, imgFile);
        return WxImgProcQrCodeResult.fromJson((String)result);
    }

    public WxImgProcSuperResolutionResult superResolution(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.service.get(String.format(SUPER_RESOLUTION, imgUrl), null);
        return WxImgProcSuperResolutionResult.fromJson((String)result);
    }

    public WxImgProcSuperResolutionResult superResolution(File imgFile) throws WxErrorException {
        String result = (String)this.service.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.service.getRequestHttp()), FILE_SUPER_RESOLUTION, imgFile);
        return WxImgProcSuperResolutionResult.fromJson((String)result);
    }

    public WxImgProcAiCropResult aiCrop(String imgUrl) throws WxErrorException {
        return this.aiCrop(imgUrl, "");
    }

    public WxImgProcAiCropResult aiCrop(String imgUrl, String ratios) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (StringUtils.isEmpty((CharSequence)ratios)) {
            ratios = "";
        }
        String result = this.service.get(String.format(AI_CROP, imgUrl, ratios), null);
        return WxImgProcAiCropResult.fromJson((String)result);
    }

    public WxImgProcAiCropResult aiCrop(File imgFile) throws WxErrorException {
        return this.aiCrop(imgFile, "");
    }

    public WxImgProcAiCropResult aiCrop(File imgFile, String ratios) throws WxErrorException {
        if (StringUtils.isEmpty((CharSequence)ratios)) {
            ratios = "";
        }
        String result = (String)this.service.execute(OcrDiscernRequestExecutor.create((RequestHttp)this.service.getRequestHttp()), String.format(FILE_AI_CROP, ratios), imgFile);
        return WxImgProcAiCropResult.fromJson((String)result);
    }

    public WxMaImgProcServiceImpl(WxMaService service) {
        this.service = service;
    }
}

