/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpOaWeDocService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.oa.doc.WxCpDocCreateData;
import me.chanjar.weixin.cp.bean.oa.doc.WxCpDocCreateRequest;
import me.chanjar.weixin.cp.bean.oa.doc.WxCpDocInfo;
import me.chanjar.weixin.cp.bean.oa.doc.WxCpDocRenameRequest;
import me.chanjar.weixin.cp.bean.oa.doc.WxCpDocShare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpOaWeDocServiceImpl
implements WxCpOaWeDocService {
    private static final Logger log = LoggerFactory.getLogger(WxCpOaWeDocServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public WxCpDocCreateData docCreate(@NonNull WxCpDocCreateRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedoc/create_doc");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpDocCreateData.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp docRename(@NonNull WxCpDocRenameRequest request) throws WxErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedoc/rename_doc");
        String responseContent = this.cpService.post(apiUrl, request.toJson());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp docDelete(String docId, String formId) throws WxErrorException {
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedoc/del_doc");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("docid", docId);
        jsonObject.addProperty("formid", formId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpDocInfo docInfo(@NonNull String docId) throws WxErrorException {
        if (docId == null) {
            throw new NullPointerException("docId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedoc/get_doc_base_info");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("docid", docId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpDocInfo.fromJson(responseContent);
    }

    @Override
    public WxCpDocShare docShare(@NonNull String docId) throws WxErrorException {
        if (docId == null) {
            throw new NullPointerException("docId is marked non-null but is null");
        }
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/wedoc/doc_share");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("docid", docId);
        String responseContent = this.cpService.post(apiUrl, jsonObject.toString());
        return WxCpDocShare.fromJson(responseContent);
    }

    public WxCpOaWeDocServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

