/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.corpgroup.service.impl;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.bean.corpgroup.WxCpCorpGroupCorpGetTokenReq;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpUser;
import me.chanjar.weixin.cp.corpgroup.service.WxCpCgService;
import me.chanjar.weixin.cp.corpgroup.service.WxCpLinkedCorpService;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpLinkedCorpServiceImpl
implements WxCpLinkedCorpService {
    private final WxCpCgService cpCgService;

    @Override
    public WxCpLinkedCorpAgentPerm getLinkedCorpAgentPerm(WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.cpCgService.getWxCpCorpGroupConfigStorage().getApiUrl("/cgi-bin/linkedcorp/agent/get_perm_list");
        JsonObject jsonObject = new JsonObject();
        String responseContent = this.cpCgService.post(url, jsonObject.toString(), req);
        return (WxCpLinkedCorpAgentPerm)WxCpGsonBuilder.create().fromJson(responseContent, WxCpLinkedCorpAgentPerm.class);
    }

    @Override
    public WxCpLinkedCorpUser getLinkedCorpUser(String userId, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.cpCgService.getWxCpCorpGroupConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/get");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        String responseContent = this.cpCgService.post(url, jsonObject.toString(), req);
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (WxCpLinkedCorpUser)WxCpGsonBuilder.create().fromJson(tmpJson.get("user_info"), new TypeToken<WxCpLinkedCorpUser>(){}.getType());
    }

    @Override
    public List<WxCpLinkedCorpUser> getLinkedCorpSimpleUserList(String departmentId, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.cpCgService.getWxCpCorpGroupConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/simplelist");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.cpCgService.post(url, jsonObject.toString(), req);
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("userlist"), new TypeToken<List<WxCpLinkedCorpUser>>(){}.getType());
    }

    @Override
    public List<WxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.cpCgService.getWxCpCorpGroupConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/list");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.cpCgService.post(url, jsonObject.toString(), req);
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("userlist"), new TypeToken<List<WxCpLinkedCorpUser>>(){}.getType());
    }

    @Override
    public List<WxCpLinkedCorpDepartment> getLinkedCorpDepartmentList(String departmentId, WxCpCorpGroupCorpGetTokenReq req) throws WxErrorException {
        String url = this.cpCgService.getWxCpCorpGroupConfigStorage().getApiUrl("/cgi-bin/linkedcorp/department/list");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.cpCgService.post(url, jsonObject.toString(), req);
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("department_list"), new TypeToken<List<WxCpLinkedCorpDepartment>>(){}.getType());
    }

    public WxCpLinkedCorpServiceImpl(WxCpCgService cpCgService) {
        this.cpCgService = cpCgService;
    }
}

