/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.config.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.cp.config.WxCpCorpGroupConfigStorage;
import org.apache.commons.lang3.StringUtils;

public class WxCpCorpGroupRedissonConfigImpl
implements WxCpCorpGroupConfigStorage,
Serializable {
    private final transient Map<String, Lock> corpAccessTokenLocker = new ConcurrentHashMap<String, Lock>();
    protected static final String LOCK_KEY = "wechat_cg_lock:";
    protected static final String LOCKER_CORP_ACCESS_TOKEN = "corpAccessTokenLock";
    protected static final String CG_ACCESS_TOKEN_KEY = "wechat_cg_access_token_key:";
    @NonNull
    private final WxRedisOps wxRedisOps;
    private String keyPrefix = "";
    private volatile String httpProxyHost;
    private volatile int httpProxyPort;
    private volatile String httpProxyUsername;
    private volatile String httpProxyPassword;
    private volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    private volatile String baseApiUrl;
    private volatile String corpId;
    private volatile Integer agentId;

    @Override
    public void setBaseApiUrl(String baseUrl) {
        this.baseApiUrl = baseUrl;
    }

    @Override
    public String getApiUrl(String path) {
        if (this.baseApiUrl == null) {
            this.baseApiUrl = "https://qyapi.weixin.qq.com";
        }
        return this.baseApiUrl + path;
    }

    @Override
    public String getCorpId() {
        return this.corpId;
    }

    @Override
    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    @Override
    public Integer getAgentId() {
        return this.agentId;
    }

    @Override
    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    @Override
    public void updateCorpAccessToken(String corpId, Integer agentId, String corpAccessToken, int expiresInSeconds) {
        this.wxRedisOps.setValue(this.generateAccessTokenKey(corpId, agentId), corpAccessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getCorpAccessToken(String corpId, Integer agentId) {
        return this.wxRedisOps.getValue(this.generateAccessTokenKey(corpId, agentId));
    }

    @Override
    public WxAccessToken getCorpAccessTokenEntity(String corpId, Integer agentId) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        String accessToken = this.wxRedisOps.getValue(key);
        Long expire = this.wxRedisOps.getExpire(key);
        if (StringUtils.isBlank((CharSequence)accessToken) || expire == null || expire == 0L || expire == -2L) {
            return new WxAccessToken();
        }
        WxAccessToken accessTokenEntity = new WxAccessToken();
        accessTokenEntity.setAccessToken(accessToken);
        accessTokenEntity.setExpiresIn(Math.max(Math.toIntExact(expire), 0));
        return accessTokenEntity;
    }

    @Override
    public boolean isCorpAccessTokenExpired(String corpId, Integer agentId) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        return this.wxRedisOps.getExpire(key) == 0L || this.wxRedisOps.getExpire(key) == -2L;
    }

    @Override
    public void expireCorpAccessToken(String corpId, Integer agentId) {
        this.wxRedisOps.expire(this.generateAccessTokenKey(corpId, agentId), 0, TimeUnit.SECONDS);
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    @Override
    public Lock getCorpAccessTokenLock(String corpId, Integer agentId) {
        return this.getLockByKey(String.join((CharSequence)":", corpId, String.valueOf(agentId), LOCKER_CORP_ACCESS_TOKEN));
    }

    private String generateAccessTokenKey(String corpId, Integer agentId) {
        return String.join((CharSequence)":", this.keyPrefix, CG_ACCESS_TOKEN_KEY, corpId, String.valueOf(agentId));
    }

    private Lock getLockByKey(String key) {
        return this.wxRedisOps.getLock(String.join((CharSequence)":", this.keyPrefix, LOCK_KEY, key));
    }

    WxCpCorpGroupRedissonConfigImpl(@NonNull WxRedisOps wxRedisOps, String keyPrefix, String httpProxyHost, int httpProxyPort, String httpProxyUsername, String httpProxyPassword, ApacheHttpClientBuilder apacheHttpClientBuilder, String baseApiUrl, String corpId, Integer agentId) {
        if (wxRedisOps == null) {
            throw new NullPointerException("wxRedisOps is marked non-null but is null");
        }
        this.wxRedisOps = wxRedisOps;
        this.keyPrefix = keyPrefix;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.httpProxyUsername = httpProxyUsername;
        this.httpProxyPassword = httpProxyPassword;
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
        this.baseApiUrl = baseApiUrl;
        this.corpId = corpId;
        this.agentId = agentId;
    }

    public static WxCpCorpGroupRedissonConfigImplBuilder builder() {
        return new WxCpCorpGroupRedissonConfigImplBuilder();
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public static class WxCpCorpGroupRedissonConfigImplBuilder {
        private WxRedisOps wxRedisOps;
        private String keyPrefix;
        private String httpProxyHost;
        private int httpProxyPort;
        private String httpProxyUsername;
        private String httpProxyPassword;
        private ApacheHttpClientBuilder apacheHttpClientBuilder;
        private String baseApiUrl;
        private String corpId;
        private Integer agentId;

        WxCpCorpGroupRedissonConfigImplBuilder() {
        }

        public WxCpCorpGroupRedissonConfigImplBuilder wxRedisOps(@NonNull WxRedisOps wxRedisOps) {
            if (wxRedisOps == null) {
                throw new NullPointerException("wxRedisOps is marked non-null but is null");
            }
            this.wxRedisOps = wxRedisOps;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder httpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder httpProxyPort(int httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder httpProxyUsername(String httpProxyUsername) {
            this.httpProxyUsername = httpProxyUsername;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder httpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder apacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
            this.apacheHttpClientBuilder = apacheHttpClientBuilder;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder baseApiUrl(String baseApiUrl) {
            this.baseApiUrl = baseApiUrl;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder corpId(String corpId) {
            this.corpId = corpId;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImplBuilder agentId(Integer agentId) {
            this.agentId = agentId;
            return this;
        }

        public WxCpCorpGroupRedissonConfigImpl build() {
            return new WxCpCorpGroupRedissonConfigImpl(this.wxRedisOps, this.keyPrefix, this.httpProxyHost, this.httpProxyPort, this.httpProxyUsername, this.httpProxyPassword, this.apacheHttpClientBuilder, this.baseApiUrl, this.corpId, this.agentId);
        }

        public String toString() {
            return "WxCpCorpGroupRedissonConfigImpl.WxCpCorpGroupRedissonConfigImplBuilder(wxRedisOps=" + this.wxRedisOps + ", keyPrefix=" + this.keyPrefix + ", httpProxyHost=" + this.httpProxyHost + ", httpProxyPort=" + this.httpProxyPort + ", httpProxyUsername=" + this.httpProxyUsername + ", httpProxyPassword=" + this.httpProxyPassword + ", apacheHttpClientBuilder=" + this.apacheHttpClientBuilder + ", baseApiUrl=" + this.baseApiUrl + ", corpId=" + this.corpId + ", agentId=" + this.agentId + ")";
        }
    }
}

