/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.List;
import me.chanjar.weixin.cp.bean.article.MpnewsArticle;
import me.chanjar.weixin.cp.bean.article.NewArticle;

public class WxCpAppChatMessage
implements Serializable {
    private static final long serialVersionUID = -5469013416372240229L;
    private String msgType;
    private String content;
    private String chatId;
    private String mediaId;
    private String title;
    private String description;
    private Boolean safe;
    private String url;
    private String btnTxt;
    private List<NewArticle> articles;
    private List<MpnewsArticle> mpnewsArticles;

    public static WxCpAppChatMessage buildTextMsg(String chatId, String content, boolean safe) {
        WxCpAppChatMessage message = new WxCpAppChatMessage();
        message.setMsgType("text");
        message.setContent(content);
        message.setChatId(chatId);
        message.setSafe(safe);
        return message;
    }

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("msgtype", this.getMsgType());
        messageJson.addProperty("chatid", this.getChatId());
        if (this.getSafe() != null && this.getSafe().booleanValue()) {
            messageJson.addProperty("safe", (Number)1);
        }
        this.handleMsgType(messageJson);
        return messageJson.toString();
    }

    private void handleMsgType(JsonObject messageJson) {
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "textcard": {
                JsonObject text = new JsonObject();
                text.addProperty("title", this.getTitle());
                text.addProperty("description", this.getDescription());
                text.addProperty("url", this.getUrl());
                text.addProperty("btntxt", this.getBtnTxt());
                messageJson.add("textcard", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("image", (JsonElement)image);
                break;
            }
            case "file": {
                JsonObject image = new JsonObject();
                image.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)image);
                break;
            }
            case "voice": {
                JsonObject voice = new JsonObject();
                voice.addProperty("media_id", this.getMediaId());
                messageJson.add("voice", (JsonElement)voice);
                break;
            }
            case "video": {
                JsonObject video = new JsonObject();
                video.addProperty("media_id", this.getMediaId());
                video.addProperty("title", this.getTitle());
                video.addProperty("description", this.getDescription());
                messageJson.add("video", (JsonElement)video);
                break;
            }
            case "news": {
                JsonObject newsJsonObject = new JsonObject();
                JsonArray articleJsonArray = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    articleJsonArray.add((JsonElement)articleJson);
                }
                newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                messageJson.add("news", (JsonElement)newsJsonObject);
                break;
            }
            case "mpnews": {
                JsonObject newsJsonObject = new JsonObject();
                if (this.getMediaId() != null) {
                    newsJsonObject.addProperty("media_id", this.getMediaId());
                } else {
                    JsonArray articleJsonArray = new JsonArray();
                    for (MpnewsArticle article : this.getMpnewsArticles()) {
                        JsonObject articleJson = new JsonObject();
                        articleJson.addProperty("title", article.getTitle());
                        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
                        articleJson.addProperty("author", article.getAuthor());
                        articleJson.addProperty("content_source_url", article.getContentSourceUrl());
                        articleJson.addProperty("content", article.getContent());
                        articleJson.addProperty("digest", article.getDigest());
                        articleJsonArray.add((JsonElement)articleJson);
                    }
                    newsJsonObject.add("articles", (JsonElement)articleJsonArray);
                }
                messageJson.add("mpnews", (JsonElement)newsJsonObject);
                break;
            }
        }
    }

    public static WxCpAppChatMessageBuilder builder() {
        return new WxCpAppChatMessageBuilder();
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public String getChatId() {
        return this.chatId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getSafe() {
        return this.safe;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBtnTxt() {
        return this.btnTxt;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public List<MpnewsArticle> getMpnewsArticles() {
        return this.mpnewsArticles;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSafe(Boolean safe) {
        this.safe = safe;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBtnTxt(String btnTxt) {
        this.btnTxt = btnTxt;
    }

    public void setArticles(List<NewArticle> articles) {
        this.articles = articles;
    }

    public void setMpnewsArticles(List<MpnewsArticle> mpnewsArticles) {
        this.mpnewsArticles = mpnewsArticles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpAppChatMessage)) {
            return false;
        }
        WxCpAppChatMessage other = (WxCpAppChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$safe = this.getSafe();
        Boolean other$safe = other.getSafe();
        if (this$safe == null ? other$safe != null : !((Object)this$safe).equals(other$safe)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$btnTxt = this.getBtnTxt();
        String other$btnTxt = other.getBtnTxt();
        if (this$btnTxt == null ? other$btnTxt != null : !this$btnTxt.equals(other$btnTxt)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        List<MpnewsArticle> this$mpnewsArticles = this.getMpnewsArticles();
        List<MpnewsArticle> other$mpnewsArticles = other.getMpnewsArticles();
        return !(this$mpnewsArticles == null ? other$mpnewsArticles != null : !((Object)this$mpnewsArticles).equals(other$mpnewsArticles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpAppChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $safe = this.getSafe();
        result = result * 59 + ($safe == null ? 43 : ((Object)$safe).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $btnTxt = this.getBtnTxt();
        result = result * 59 + ($btnTxt == null ? 43 : $btnTxt.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        List<MpnewsArticle> $mpnewsArticles = this.getMpnewsArticles();
        result = result * 59 + ($mpnewsArticles == null ? 43 : ((Object)$mpnewsArticles).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpAppChatMessage(msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", chatId=" + this.getChatId() + ", mediaId=" + this.getMediaId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", safe=" + this.getSafe() + ", url=" + this.getUrl() + ", btnTxt=" + this.getBtnTxt() + ", articles=" + this.getArticles() + ", mpnewsArticles=" + this.getMpnewsArticles() + ")";
    }

    public WxCpAppChatMessage() {
    }

    public WxCpAppChatMessage(String msgType, String content, String chatId, String mediaId, String title, String description, Boolean safe, String url, String btnTxt, List<NewArticle> articles, List<MpnewsArticle> mpnewsArticles) {
        this.msgType = msgType;
        this.content = content;
        this.chatId = chatId;
        this.mediaId = mediaId;
        this.title = title;
        this.description = description;
        this.safe = safe;
        this.url = url;
        this.btnTxt = btnTxt;
        this.articles = articles;
        this.mpnewsArticles = mpnewsArticles;
    }

    public static class WxCpAppChatMessageBuilder {
        private String msgType;
        private String content;
        private String chatId;
        private String mediaId;
        private String title;
        private String description;
        private Boolean safe;
        private String url;
        private String btnTxt;
        private List<NewArticle> articles;
        private List<MpnewsArticle> mpnewsArticles;

        WxCpAppChatMessageBuilder() {
        }

        public WxCpAppChatMessageBuilder msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        public WxCpAppChatMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public WxCpAppChatMessageBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        public WxCpAppChatMessageBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public WxCpAppChatMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WxCpAppChatMessageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WxCpAppChatMessageBuilder safe(Boolean safe) {
            this.safe = safe;
            return this;
        }

        public WxCpAppChatMessageBuilder url(String url) {
            this.url = url;
            return this;
        }

        public WxCpAppChatMessageBuilder btnTxt(String btnTxt) {
            this.btnTxt = btnTxt;
            return this;
        }

        public WxCpAppChatMessageBuilder articles(List<NewArticle> articles) {
            this.articles = articles;
            return this;
        }

        public WxCpAppChatMessageBuilder mpnewsArticles(List<MpnewsArticle> mpnewsArticles) {
            this.mpnewsArticles = mpnewsArticles;
            return this;
        }

        public WxCpAppChatMessage build() {
            return new WxCpAppChatMessage(this.msgType, this.content, this.chatId, this.mediaId, this.title, this.description, this.safe, this.url, this.btnTxt, this.articles, this.mpnewsArticles);
        }

        public String toString() {
            return "WxCpAppChatMessage.WxCpAppChatMessageBuilder(msgType=" + this.msgType + ", content=" + this.content + ", chatId=" + this.chatId + ", mediaId=" + this.mediaId + ", title=" + this.title + ", description=" + this.description + ", safe=" + this.safe + ", url=" + this.url + ", btnTxt=" + this.btnTxt + ", articles=" + this.articles + ", mpnewsArticles=" + this.mpnewsArticles + ")";
        }
    }
}

