/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.redis;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.common.util.locks.RedisTemplateSimpleDistributedLock;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisTemplateWxRedisOps
implements WxRedisOps {
    private final StringRedisTemplate redisTemplate;

    @Override
    public String getValue(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public void setValue(String key, String value, int expire, TimeUnit timeUnit) {
        if (expire <= 0) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, (long)expire, timeUnit);
        }
    }

    @Override
    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    @Override
    public void expire(String key, int expire, TimeUnit timeUnit) {
        this.redisTemplate.expire((Object)key, (long)expire, timeUnit);
    }

    @Override
    public Lock getLock(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new RedisTemplateSimpleDistributedLock(this.redisTemplate, key, 60000);
    }

    public RedisTemplateWxRedisOps(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

