/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.BinanceApiWebSocketClient;
import com.binance.api.client.domain.event.AggTradeEvent;
import com.binance.api.client.domain.event.CandlestickEvent;
import com.binance.api.client.domain.event.DepthEvent;
import com.binance.api.client.domain.event.UserDataUpdateEvent;
import com.binance.api.client.domain.market.CandlestickInterval;
import com.binance.api.client.impl.BinanceApiWebSocketListener;
import java.io.Closeable;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class BinanceApiWebSocketClientImpl
implements BinanceApiWebSocketClient,
Closeable {
    private OkHttpClient client = new OkHttpClient();

    @Override
    public void onDepthEvent(String symbol, BinanceApiCallback<DepthEvent> callback) {
        String channel = String.format("%s@depth", symbol);
        this.createNewWebSocket(channel, new BinanceApiWebSocketListener<DepthEvent>(callback, DepthEvent.class));
    }

    @Override
    public void onCandlestickEvent(String symbol, CandlestickInterval interval, BinanceApiCallback<CandlestickEvent> callback) {
        String channel = String.format("%s@kline_%s", symbol, interval.getIntervalId());
        this.createNewWebSocket(channel, new BinanceApiWebSocketListener<CandlestickEvent>(callback, CandlestickEvent.class));
    }

    @Override
    public void onAggTradeEvent(String symbol, BinanceApiCallback<AggTradeEvent> callback) {
        String channel = String.format("%s@aggTrade", symbol);
        this.createNewWebSocket(channel, new BinanceApiWebSocketListener<AggTradeEvent>(callback, AggTradeEvent.class));
    }

    @Override
    public void onUserDataUpdateEvent(String listenKey, BinanceApiCallback<UserDataUpdateEvent> callback) {
        this.createNewWebSocket(listenKey, new BinanceApiWebSocketListener<UserDataUpdateEvent>(callback, UserDataUpdateEvent.class));
    }

    private void createNewWebSocket(String channel, BinanceApiWebSocketListener<?> listener) {
        String streamingUrl = String.format("%s/%s", "wss://stream.binance.com:9443/ws", channel);
        Request request = new Request.Builder().url(streamingUrl).build();
        this.client.newWebSocket(request, listener);
    }

    @Override
    public void close() throws IOException {
        this.client.dispatcher().executorService().shutdown();
    }
}

