/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.general;

import com.binance.api.client.domain.OrderType;
import com.binance.api.client.domain.general.FilterType;
import com.binance.api.client.domain.general.SymbolFilter;
import com.binance.api.client.domain.general.SymbolStatus;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SymbolInfo {
    private String symbol;
    private SymbolStatus status;
    private String baseAsset;
    private Integer baseAssetPrecision;
    private String quoteAsset;
    private Integer quotePrecision;
    private List<OrderType> orderTypes;
    private boolean icebergAllowed;
    private List<SymbolFilter> filters;

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public SymbolStatus getStatus() {
        return this.status;
    }

    public void setStatus(SymbolStatus status) {
        this.status = status;
    }

    public String getBaseAsset() {
        return this.baseAsset;
    }

    public void setBaseAsset(String baseAsset) {
        this.baseAsset = baseAsset;
    }

    public Integer getBaseAssetPrecision() {
        return this.baseAssetPrecision;
    }

    public void setBaseAssetPrecision(Integer baseAssetPrecision) {
        this.baseAssetPrecision = baseAssetPrecision;
    }

    public String getQuoteAsset() {
        return this.quoteAsset;
    }

    public void setQuoteAsset(String quoteAsset) {
        this.quoteAsset = quoteAsset;
    }

    public Integer getQuotePrecision() {
        return this.quotePrecision;
    }

    public void setQuotePrecision(Integer quotePrecision) {
        this.quotePrecision = quotePrecision;
    }

    public List<OrderType> getOrderTypes() {
        return this.orderTypes;
    }

    public void setOrderTypes(List<OrderType> orderTypes) {
        this.orderTypes = orderTypes;
    }

    public boolean isIcebergAllowed() {
        return this.icebergAllowed;
    }

    public void setIcebergAllowed(boolean icebergAllowed) {
        this.icebergAllowed = icebergAllowed;
    }

    public List<SymbolFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<SymbolFilter> filters) {
        this.filters = filters;
    }

    public SymbolFilter getSymbolFilter(FilterType filterType) {
        return this.filters.stream().filter(symbolFilter -> symbolFilter.getFilterType() == filterType).findFirst().get();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("symbol", (Object)this.symbol).append("status", (Object)this.status).append("baseAsset", (Object)this.baseAsset).append("baseAssetPrecision", (Object)this.baseAssetPrecision).append("quoteAsset", (Object)this.quoteAsset).append("quotePrecision", (Object)this.quotePrecision).append("orderTypes", this.orderTypes).append("icebergAllowed", this.icebergAllowed).append("filters", this.filters).toString();
    }
}

