/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.event;

import com.binance.api.client.domain.event.AccountUpdateEvent;
import com.binance.api.client.domain.event.OrderTradeUpdateEvent;
import com.binance.api.client.domain.event.UserDataUpdateEventDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=UserDataUpdateEventDeserializer.class)
public class UserDataUpdateEvent {
    private UserDataUpdateEventType eventType;
    private long eventTime;
    private AccountUpdateEvent accountUpdateEvent;
    private OrderTradeUpdateEvent orderTradeUpdateEvent;

    public UserDataUpdateEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(UserDataUpdateEventType eventType) {
        this.eventType = eventType;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public AccountUpdateEvent getAccountUpdateEvent() {
        return this.accountUpdateEvent;
    }

    public void setAccountUpdateEvent(AccountUpdateEvent accountUpdateEvent) {
        this.accountUpdateEvent = accountUpdateEvent;
    }

    public OrderTradeUpdateEvent getOrderTradeUpdateEvent() {
        return this.orderTradeUpdateEvent;
    }

    public void setOrderTradeUpdateEvent(OrderTradeUpdateEvent orderTradeUpdateEvent) {
        this.orderTradeUpdateEvent = orderTradeUpdateEvent;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("eventType", (Object)this.eventType).append("eventTime", this.eventTime);
        if (this.eventType == UserDataUpdateEventType.ACCOUNT_UPDATE) {
            sb.append("accountUpdateEvent", (Object)this.accountUpdateEvent);
        } else {
            sb.append("orderTradeUpdateEvent", (Object)this.orderTradeUpdateEvent);
        }
        return sb.toString();
    }

    public static enum UserDataUpdateEventType {
        ACCOUNT_UPDATE("outboundAccountInfo"),
        ORDER_TRADE_UPDATE("executionReport");

        private final String eventTypeId;

        private UserDataUpdateEventType(String eventTypeId) {
            this.eventTypeId = eventTypeId;
        }

        public String getEventTypeId() {
            return this.eventTypeId;
        }

        public static UserDataUpdateEventType fromEventTypeId(String eventTypeId) {
            if (UserDataUpdateEventType.ACCOUNT_UPDATE.eventTypeId.equals(eventTypeId)) {
                return ACCOUNT_UPDATE;
            }
            if (UserDataUpdateEventType.ORDER_TRADE_UPDATE.eventTypeId.equals(eventTypeId)) {
                return ORDER_TRADE_UPDATE;
            }
            throw new IllegalArgumentException("Unrecognized user data update event type id: " + eventTypeId);
        }
    }
}

