/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiAsyncRestClient;
import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.domain.account.Account;
import com.binance.api.client.domain.account.DepositAddress;
import com.binance.api.client.domain.account.DepositHistory;
import com.binance.api.client.domain.account.NewOrder;
import com.binance.api.client.domain.account.NewOrderResponse;
import com.binance.api.client.domain.account.Order;
import com.binance.api.client.domain.account.Trade;
import com.binance.api.client.domain.account.TradeHistoryItem;
import com.binance.api.client.domain.account.WithdrawHistory;
import com.binance.api.client.domain.account.WithdrawResult;
import com.binance.api.client.domain.account.request.AllOrdersRequest;
import com.binance.api.client.domain.account.request.CancelOrderRequest;
import com.binance.api.client.domain.account.request.CancelOrderResponse;
import com.binance.api.client.domain.account.request.OrderRequest;
import com.binance.api.client.domain.account.request.OrderStatusRequest;
import com.binance.api.client.domain.event.ListenKey;
import com.binance.api.client.domain.general.Asset;
import com.binance.api.client.domain.general.ExchangeInfo;
import com.binance.api.client.domain.general.ServerTime;
import com.binance.api.client.domain.market.AggTrade;
import com.binance.api.client.domain.market.BookTicker;
import com.binance.api.client.domain.market.Candlestick;
import com.binance.api.client.domain.market.CandlestickInterval;
import com.binance.api.client.domain.market.OrderBook;
import com.binance.api.client.domain.market.TickerPrice;
import com.binance.api.client.domain.market.TickerStatistics;
import com.binance.api.client.impl.BinanceApiCallbackAdapter;
import com.binance.api.client.impl.BinanceApiService;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.util.List;

public class BinanceApiAsyncRestClientImpl
implements BinanceApiAsyncRestClient {
    private final BinanceApiService binanceApiService;

    public BinanceApiAsyncRestClientImpl(String apiKey, String secret) {
        this.binanceApiService = BinanceApiServiceGenerator.createService(BinanceApiService.class, apiKey, secret);
    }

    @Override
    public void ping(BinanceApiCallback<Void> callback) {
        this.binanceApiService.ping().enqueue(new BinanceApiCallbackAdapter<Void>(callback));
    }

    @Override
    public void getServerTime(BinanceApiCallback<ServerTime> callback) {
        this.binanceApiService.getServerTime().enqueue(new BinanceApiCallbackAdapter<ServerTime>(callback));
    }

    @Override
    public void getExchangeInfo(BinanceApiCallback<ExchangeInfo> callback) {
        this.binanceApiService.getExchangeInfo().enqueue(new BinanceApiCallbackAdapter<ExchangeInfo>(callback));
    }

    @Override
    public void getAllAssets(BinanceApiCallback<List<Asset>> callback) {
        this.binanceApiService.getAllAssets("https://www.binance.com/assetWithdraw/getAllAsset.html").enqueue(new BinanceApiCallbackAdapter<List<Asset>>(callback));
    }

    @Override
    public void getOrderBook(String symbol, Integer limit, BinanceApiCallback<OrderBook> callback) {
        this.binanceApiService.getOrderBook(symbol, limit).enqueue(new BinanceApiCallbackAdapter<OrderBook>(callback));
    }

    @Override
    public void getTrades(String symbol, Integer limit, BinanceApiCallback<List<TradeHistoryItem>> callback) {
        this.binanceApiService.getTrades(symbol, limit).enqueue(new BinanceApiCallbackAdapter<List<TradeHistoryItem>>(callback));
    }

    @Override
    public void getHistoricalTrades(String symbol, Integer limit, Long fromId, BinanceApiCallback<List<TradeHistoryItem>> callback) {
        this.binanceApiService.getHistoricalTrades(symbol, limit, fromId).enqueue(new BinanceApiCallbackAdapter<List<TradeHistoryItem>>(callback));
    }

    @Override
    public void getAggTrades(String symbol, String fromId, Integer limit, Long startTime, Long endTime, BinanceApiCallback<List<AggTrade>> callback) {
        this.binanceApiService.getAggTrades(symbol, fromId, limit, startTime, endTime).enqueue(new BinanceApiCallbackAdapter<List<AggTrade>>(callback));
    }

    @Override
    public void getAggTrades(String symbol, BinanceApiCallback<List<AggTrade>> callback) {
        this.getAggTrades(symbol, null, null, null, null, callback);
    }

    @Override
    public void getCandlestickBars(String symbol, CandlestickInterval interval, Integer limit, Long startTime, Long endTime, BinanceApiCallback<List<Candlestick>> callback) {
        this.binanceApiService.getCandlestickBars(symbol, interval.getIntervalId(), limit, startTime, endTime).enqueue(new BinanceApiCallbackAdapter<List<Candlestick>>(callback));
    }

    @Override
    public void getCandlestickBars(String symbol, CandlestickInterval interval, BinanceApiCallback<List<Candlestick>> callback) {
        this.getCandlestickBars(symbol, interval, null, null, null, callback);
    }

    @Override
    public void get24HrPriceStatistics(String symbol, BinanceApiCallback<TickerStatistics> callback) {
        this.binanceApiService.get24HrPriceStatistics(symbol).enqueue(new BinanceApiCallbackAdapter<TickerStatistics>(callback));
    }

    @Override
    public void getAll24HrPriceStatistics(BinanceApiCallback<List<TickerStatistics>> callback) {
        this.binanceApiService.getAll24HrPriceStatistics().enqueue(new BinanceApiCallbackAdapter<List<TickerStatistics>>(callback));
    }

    @Override
    public void getAllPrices(BinanceApiCallback<List<TickerPrice>> callback) {
        this.binanceApiService.getLatestPrices().enqueue(new BinanceApiCallbackAdapter<List<TickerPrice>>(callback));
    }

    @Override
    public void getPrice(String symbol, BinanceApiCallback<TickerPrice> callback) {
        this.binanceApiService.getLatestPrice(symbol).enqueue(new BinanceApiCallbackAdapter<TickerPrice>(callback));
    }

    @Override
    public void getBookTickers(BinanceApiCallback<List<BookTicker>> callback) {
        this.binanceApiService.getBookTickers().enqueue(new BinanceApiCallbackAdapter<List<BookTicker>>(callback));
    }

    @Override
    public void newOrder(NewOrder order, BinanceApiCallback<NewOrderResponse> callback) {
        this.binanceApiService.newOrder(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getNewClientOrderId(), order.getStopPrice(), order.getIcebergQty(), order.getNewOrderRespType(), order.getRecvWindow(), order.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<NewOrderResponse>(callback));
    }

    @Override
    public void newOrderTest(NewOrder order, BinanceApiCallback<Void> callback) {
        this.binanceApiService.newOrderTest(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getNewClientOrderId(), order.getStopPrice(), order.getIcebergQty(), order.getNewOrderRespType(), order.getRecvWindow(), order.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<Void>(callback));
    }

    @Override
    public void getOrderStatus(OrderStatusRequest orderStatusRequest, BinanceApiCallback<Order> callback) {
        this.binanceApiService.getOrderStatus(orderStatusRequest.getSymbol(), orderStatusRequest.getOrderId(), orderStatusRequest.getOrigClientOrderId(), orderStatusRequest.getRecvWindow(), orderStatusRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<Order>(callback));
    }

    @Override
    public void cancelOrder(CancelOrderRequest cancelOrderRequest, BinanceApiCallback<CancelOrderResponse> callback) {
        this.binanceApiService.cancelOrder(cancelOrderRequest.getSymbol(), cancelOrderRequest.getOrderId(), cancelOrderRequest.getOrigClientOrderId(), cancelOrderRequest.getNewClientOrderId(), cancelOrderRequest.getRecvWindow(), cancelOrderRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<CancelOrderResponse>(callback));
    }

    @Override
    public void getOpenOrders(OrderRequest orderRequest, BinanceApiCallback<List<Order>> callback) {
        this.binanceApiService.getOpenOrders(orderRequest.getSymbol(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<List<Order>>(callback));
    }

    @Override
    public void getAllOrders(AllOrdersRequest orderRequest, BinanceApiCallback<List<Order>> callback) {
        this.binanceApiService.getAllOrders(orderRequest.getSymbol(), orderRequest.getOrderId(), orderRequest.getLimit(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<List<Order>>(callback));
    }

    @Override
    public void getAccount(Long recvWindow, Long timestamp, BinanceApiCallback<Account> callback) {
        this.binanceApiService.getAccount(recvWindow, timestamp).enqueue(new BinanceApiCallbackAdapter<Account>(callback));
    }

    @Override
    public void getAccount(BinanceApiCallback<Account> callback) {
        long timestamp = System.currentTimeMillis();
        this.binanceApiService.getAccount(6000000L, timestamp).enqueue(new BinanceApiCallbackAdapter<Account>(callback));
    }

    @Override
    public void getMyTrades(String symbol, Integer limit, Long fromId, Long recvWindow, Long timestamp, BinanceApiCallback<List<Trade>> callback) {
        this.binanceApiService.getMyTrades(symbol, limit, fromId, recvWindow, timestamp).enqueue(new BinanceApiCallbackAdapter<List<Trade>>(callback));
    }

    @Override
    public void getMyTrades(String symbol, Integer limit, BinanceApiCallback<List<Trade>> callback) {
        this.getMyTrades(symbol, limit, null, 6000000L, System.currentTimeMillis(), callback);
    }

    @Override
    public void getMyTrades(String symbol, BinanceApiCallback<List<Trade>> callback) {
        this.getMyTrades(symbol, null, null, 6000000L, System.currentTimeMillis(), callback);
    }

    @Override
    public void withdraw(String asset, String address, String amount, String name, String addressTag, BinanceApiCallback<WithdrawResult> callback) {
        this.binanceApiService.withdraw(asset, address, amount, name, addressTag, 6000000L, System.currentTimeMillis()).enqueue(new BinanceApiCallbackAdapter<WithdrawResult>(callback));
    }

    @Override
    public void getDepositHistory(String asset, BinanceApiCallback<DepositHistory> callback) {
        this.binanceApiService.getDepositHistory(asset, 6000000L, System.currentTimeMillis()).enqueue(new BinanceApiCallbackAdapter<DepositHistory>(callback));
    }

    @Override
    public void getWithdrawHistory(String asset, BinanceApiCallback<WithdrawHistory> callback) {
        this.binanceApiService.getWithdrawHistory(asset, 6000000L, System.currentTimeMillis()).enqueue(new BinanceApiCallbackAdapter<WithdrawHistory>(callback));
    }

    @Override
    public void getDepositAddress(String asset, BinanceApiCallback<DepositAddress> callback) {
        this.binanceApiService.getDepositAddress(asset, 6000000L, System.currentTimeMillis()).enqueue(new BinanceApiCallbackAdapter<DepositAddress>(callback));
    }

    @Override
    public void startUserDataStream(BinanceApiCallback<ListenKey> callback) {
        this.binanceApiService.startUserDataStream().enqueue(new BinanceApiCallbackAdapter<ListenKey>(callback));
    }

    @Override
    public void keepAliveUserDataStream(String listenKey, BinanceApiCallback<Void> callback) {
        this.binanceApiService.keepAliveUserDataStream(listenKey).enqueue(new BinanceApiCallbackAdapter<Void>(callback));
    }

    @Override
    public void closeUserDataStream(String listenKey, BinanceApiCallback<Void> callback) {
        this.binanceApiService.closeAliveUserDataStream(listenKey).enqueue(new BinanceApiCallbackAdapter<Void>(callback));
    }
}

