/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.account;

import com.binance.api.client.constant.BinanceApiConstants;
import com.binance.api.client.domain.account.AssetBalance;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Account {
    private int makerCommission;
    private int takerCommission;
    private int buyerCommission;
    private int sellerCommission;
    private boolean canTrade;
    private boolean canWithdraw;
    private boolean canDeposit;
    private long updateTime;
    private List<AssetBalance> balances;

    public int getMakerCommission() {
        return this.makerCommission;
    }

    public void setMakerCommission(int makerCommission) {
        this.makerCommission = makerCommission;
    }

    public int getTakerCommission() {
        return this.takerCommission;
    }

    public void setTakerCommission(int takerCommission) {
        this.takerCommission = takerCommission;
    }

    public int getBuyerCommission() {
        return this.buyerCommission;
    }

    public void setBuyerCommission(int buyerCommission) {
        this.buyerCommission = buyerCommission;
    }

    public int getSellerCommission() {
        return this.sellerCommission;
    }

    public void setSellerCommission(int sellerCommission) {
        this.sellerCommission = sellerCommission;
    }

    public boolean isCanTrade() {
        return this.canTrade;
    }

    public void setCanTrade(boolean canTrade) {
        this.canTrade = canTrade;
    }

    public boolean isCanWithdraw() {
        return this.canWithdraw;
    }

    public void setCanWithdraw(boolean canWithdraw) {
        this.canWithdraw = canWithdraw;
    }

    public boolean isCanDeposit() {
        return this.canDeposit;
    }

    public void setCanDeposit(boolean canDeposit) {
        this.canDeposit = canDeposit;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public List<AssetBalance> getBalances() {
        return this.balances;
    }

    public void setBalances(List<AssetBalance> balances) {
        this.balances = balances;
    }

    public AssetBalance getAssetBalance(String symbol) {
        for (AssetBalance assetBalance : this.balances) {
            if (!symbol.equals(assetBalance.getAsset())) continue;
            return assetBalance;
        }
        AssetBalance emptyBalance = new AssetBalance();
        emptyBalance.setAsset(symbol);
        emptyBalance.setFree("0");
        emptyBalance.setLocked("0");
        return emptyBalance;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, BinanceApiConstants.TO_STRING_BUILDER_STYLE).append("makerCommission", this.makerCommission).append("takerCommission", this.takerCommission).append("buyerCommission", this.buyerCommission).append("sellerCommission", this.sellerCommission).append("canTrade", this.canTrade).append("canWithdraw", this.canWithdraw).append("canDeposit", this.canDeposit).append("updateTime", this.updateTime).append("balances", this.balances).toString();
    }
}

