/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.attributes;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.github.bijoysingh.uibasics.R;

public class ImageAttributes {
    private Context context;
    private AttributeSet attributeSet;
    private int[] attrStyleable;
    private int srcStyleable;
    private int iconTintStyleable;
    private int iconPaddingStyleable;
    private int iconSizeStyleable;
    private int iconMarginStyleable;
    private int iconMarginStartStyleable;
    private int iconMarginEndStyleable;
    private int iconMarginTopStyleable;
    private int iconMarginBottomStyleable;

    public ImageAttributes(Builder builder) {
        this.context = builder.context;
        this.attributeSet = builder.attributeSet;
        this.attrStyleable = builder.attrStyleable;
        this.srcStyleable = builder.srcStyleable;
        this.iconTintStyleable = builder.iconTintStyleable;
        this.iconPaddingStyleable = builder.iconPaddingStyleable;
        this.iconSizeStyleable = builder.iconSizeStyleable;
        this.iconMarginStyleable = builder.iconMarginStyleable;
        this.iconMarginStartStyleable = builder.iconMarginStartStyleable;
        this.iconMarginEndStyleable = builder.iconMarginEndStyleable;
        this.iconMarginTopStyleable = builder.iconMarginTopStyleable;
        this.iconMarginBottomStyleable = builder.iconMarginBottomStyleable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(ImageView view) {
        TypedArray typedArray = this.context.getTheme().obtainStyledAttributes(this.attributeSet, this.attrStyleable, 0, 0);
        try {
            if (this.srcStyleable != -1) {
                int imageSrc = typedArray.getResourceId(this.srcStyleable, 0);
                if (imageSrc != 0) {
                    view.setImageResource(imageSrc);
                } else {
                    view.setVisibility(8);
                }
            }
            if (this.iconTintStyleable != -1) {
                int tintColor = typedArray.getColor(this.iconTintStyleable, -7829368);
                view.setColorFilter(tintColor);
            }
            if (this.iconPaddingStyleable != -1) {
                int padding = (int)typedArray.getDimension(this.iconPaddingStyleable, 0.0f);
                view.setPadding(padding, padding, padding, padding);
            }
            int margin = this.iconMarginStyleable != -1 ? (int)typedArray.getDimension(this.iconMarginStyleable, 0.0f) : 0;
            int marginStart = this.iconMarginStartStyleable != -1 ? (int)typedArray.getDimension(this.iconMarginStartStyleable, 0.0f) : margin;
            int marginEnd = this.iconMarginEndStyleable != -1 ? (int)typedArray.getDimension(this.iconMarginEndStyleable, 0.0f) : margin;
            int marginTop = this.iconMarginTopStyleable != -1 ? (int)typedArray.getDimension(this.iconMarginTopStyleable, 0.0f) : margin;
            int marginBottom = this.iconMarginBottomStyleable != -1 ? (int)typedArray.getDimension(this.iconMarginBottomStyleable, 0.0f) : margin;
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            params.setMargins(marginStart, marginTop, marginEnd, marginBottom);
            if (this.iconSizeStyleable != -1) {
                int size;
                view.getLayoutParams().width = size = (int)typedArray.getDimension(this.iconSizeStyleable, this.context.getResources().getDimension(R.dimen.default_icon));
                view.getLayoutParams().height = size;
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    public static class Builder {
        private Context context;
        private AttributeSet attributeSet;
        private int[] attrStyleable;
        private int srcStyleable = -1;
        private int iconTintStyleable = -1;
        private int iconPaddingStyleable = -1;
        private int iconSizeStyleable = -1;
        private int iconMarginStyleable = -1;
        private int iconMarginStartStyleable = -1;
        private int iconMarginEndStyleable = -1;
        private int iconMarginTopStyleable = -1;
        private int iconMarginBottomStyleable = -1;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setAttributeSet(AttributeSet attributeSet) {
            this.attributeSet = attributeSet;
            return this;
        }

        public Builder setAttrStyleable(int[] attrStyleable) {
            this.attrStyleable = attrStyleable;
            return this;
        }

        public Builder setSrcStyleable(int srcStyleable) {
            this.srcStyleable = srcStyleable;
            return this;
        }

        public Builder setIconTintStyleable(int iconTintStyleable) {
            this.iconTintStyleable = iconTintStyleable;
            return this;
        }

        public Builder setIconPaddingStyleable(int iconPaddingStyleable) {
            this.iconPaddingStyleable = iconPaddingStyleable;
            return this;
        }

        public Builder setIconSizeStyleable(int iconSizeStyleable) {
            this.iconSizeStyleable = iconSizeStyleable;
            return this;
        }

        public Builder setIconMarginStyleable(int iconMarginStyleable) {
            this.iconMarginStyleable = iconMarginStyleable;
            return this;
        }

        public Builder setIconMarginStartStyleable(int iconMarginStartStyleable) {
            this.iconMarginStartStyleable = iconMarginStartStyleable;
            return this;
        }

        public Builder setIconMarginEndStyleable(int iconMarginEndStyleable) {
            this.iconMarginEndStyleable = iconMarginEndStyleable;
            return this;
        }

        public Builder setIconMarginTopStyleable(int iconMarginTopStyleable) {
            this.iconMarginTopStyleable = iconMarginTopStyleable;
            return this;
        }

        public Builder setIconMarginBottomStyleable(int iconMarginBottomStyleable) {
            this.iconMarginBottomStyleable = iconMarginBottomStyleable;
            return this;
        }

        public ImageAttributes build() {
            return new ImageAttributes(this);
        }
    }
}

