/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.uibasics.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.bijoysingh.uibasics.R;
import com.github.bijoysingh.uibasics.attributes.ImageAttributes;
import com.github.bijoysingh.uibasics.attributes.TextAttributes;
import com.github.bijoysingh.uibasics.base.CustomLinearLayout;
import com.github.bijoysingh.uibasics.setters.ImageSetter;
import com.github.bijoysingh.uibasics.setters.TitleSubtitleSetter;

public class FigContentView
extends CustomLinearLayout
implements TitleSubtitleSetter,
ImageSetter {
    private ImageView mIcon;
    private TextView mTitle;
    private TextView mSubtitle;

    public FigContentView(Context context) {
        super(context);
    }

    public FigContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        new ImageAttributes.Builder().setContext(context).setAttributeSet(attrs).setAttrStyleable(R.styleable.FigTextViewBase).setSrcStyleable(R.styleable.FigTextViewBase_icon).setIconSizeStyleable(R.styleable.FigTextViewBase_iconSize).setIconPaddingStyleable(R.styleable.FigTextViewBase_iconPadding).setIconTintStyleable(R.styleable.FigTextViewBase_iconTint).setIconMarginEndStyleable(R.styleable.FigTextViewBase_iconTextGap).build().set(this.mIcon);
        new TextAttributes.Builder().setContext(context).setAttributeSet(attrs).setAttrStyleable(R.styleable.FigContentView).setTextStyleable(R.styleable.FigContentView_title).setTextColorStyleable(R.styleable.FigContentView_titleColor).setTextSizeStyleable(R.styleable.FigContentView_titleSize).setTextStyleStyleable(R.styleable.FigContentView_titleStyle).setTextPaddingStyleable(R.styleable.FigContentView_titlePadding).build().set(this.mTitle);
        new TextAttributes.Builder().setContext(context).setAttributeSet(attrs).setAttrStyleable(R.styleable.FigContentView).setTextStyleable(R.styleable.FigContentView_subtitle).setTextColorStyleable(R.styleable.FigContentView_subtitleColor).setTextSizeStyleable(R.styleable.FigContentView_subtitleSize).setTextStyleStyleable(R.styleable.FigContentView_subtitleStyle).setTextPaddingStyleable(R.styleable.FigContentView_subtitlePadding).build().set(this.mSubtitle);
    }

    public FigContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public FigContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void init() {
        this.setContentLayout(R.layout.fig_content);
        this.setOrientation(0);
        this.mIcon = (ImageView)this.findViewById(R.id.icon);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mSubtitle = (TextView)this.findViewById(R.id.subtitle);
    }

    @Override
    public void setTitle(@StringRes Integer stringResource) {
        this.mTitle.setText(stringResource.intValue());
    }

    @Override
    public void setTitle(String text) {
        this.mTitle.setText((CharSequence)text);
    }

    @Override
    public void setTitleColor(int color) {
        this.mTitle.setTextColor(color);
    }

    @Override
    public void setTitleSize(float size) {
        this.mTitle.setTextSize(size);
    }

    @Override
    public void setTitlePadding(int padding) {
        this.mTitle.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setSubtitle(@StringRes Integer stringResource) {
        this.mSubtitle.setText(stringResource.intValue());
    }

    @Override
    public void setSubtitle(String text) {
        this.mSubtitle.setText((CharSequence)text);
    }

    @Override
    public void setSubtitleColor(int color) {
        this.mSubtitle.setTextColor(color);
    }

    @Override
    public void setSubtitleSize(float size) {
        this.mSubtitle.setTextSize(size);
    }

    @Override
    public void setSubtitlePadding(int padding) {
        this.mSubtitle.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setImageResource(@DrawableRes Integer imageResource) {
        this.mIcon.setImageResource(imageResource.intValue());
    }

    @Override
    public void setImageDrawable(Drawable imageDrawable) {
        this.mIcon.setImageDrawable(imageDrawable);
    }

    @Override
    public void setImageBitmap(Bitmap bitmap) {
        this.mIcon.setImageBitmap(bitmap);
    }

    @Override
    public void setImagePadding(int padding) {
        this.mIcon.setPadding(padding, padding, padding, padding);
    }

    @Override
    public void setImageTint(int color) {
        this.mIcon.setColorFilter(color);
    }

    @Override
    public void setImageSize(int size) {
        this.mIcon.getLayoutParams().height = size;
        this.mIcon.getLayoutParams().width = size;
        this.requestLayout();
    }
}

