/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import com.github.bijoysingh.starter.util.FileManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class Store {
    private static final String STORE_NAME_PREFIX = "store__";
    private static final String DEFAULT_STORE = "DEFAULT_STORE";
    protected static Map<String, Store> sStores = new HashMap<String, Store>();
    protected final String mStoreName;
    protected final File mPathToStore;
    protected final Map<String, Object> mMemoryCache;
    protected final ExecutorService mSingleThreadExecutor;
    protected final Runnable mUpdateDiskRunnable;
    private long mLastModifiedTime = 0L;

    protected Store(Context context, String storeName) {
        this.mStoreName = storeName;
        this.mPathToStore = new File(context.getFilesDir(), STORE_NAME_PREFIX + storeName);
        this.mLastModifiedTime = this.mPathToStore.exists() ? this.mPathToStore.lastModified() : 0L;
        this.mMemoryCache = new ConcurrentHashMap<String, Object>();
        this.mSingleThreadExecutor = Executors.newSingleThreadExecutor();
        this.mUpdateDiskRunnable = new Runnable(){

            @Override
            public void run() {
                Store.this.writeToDisk();
                Store.this.onWriteCompleted();
            }
        };
    }

    public static Store get(Context context) {
        return Store.get(context, DEFAULT_STORE);
    }

    public static Store get(Context context, String storeName) {
        if (sStores.containsKey(storeName)) {
            return sStores.get(storeName);
        }
        Store store = new Store(context, storeName);
        store.initialise();
        sStores.put(storeName, store);
        return store;
    }

    public boolean has(String key) {
        return this.mMemoryCache.containsKey(key);
    }

    public void put(String key, boolean value) {
        this.putAndWrite(key, value);
    }

    public void put(String key, int value) {
        this.putAndWrite(key, value);
    }

    public void put(String key, String value) {
        this.putAndWrite(key, value);
    }

    public void put(String key, double value) {
        this.putAndWrite(key, value);
    }

    public void put(String key, float value) {
        this.putAndWrite(key, Float.valueOf(value));
    }

    public void put(String key, long value) {
        this.putAndWrite(key, value);
    }

    public void put(String key, Object value) {
        this.putAndWrite(key, value);
    }

    private void putAndWrite(String key, Object value) {
        this.mMemoryCache.put(key, value);
        this.mSingleThreadExecutor.submit(this.mUpdateDiskRunnable);
    }

    private void writeToDisk() {
        JSONObject json = new JSONObject(this.mMemoryCache);
        FileManager.writeCompressedFile(this.mPathToStore, json.toString());
    }

    public boolean get(String key, boolean defaultValue) {
        return this.has(key) ? (Boolean)this.mMemoryCache.get(key) : defaultValue;
    }

    public int get(String key, int defaultValue) {
        return this.has(key) ? Integer.parseInt(this.mMemoryCache.get(key).toString()) : defaultValue;
    }

    public String get(String key, String defaultValue) {
        return this.has(key) ? (String)this.mMemoryCache.get(key) : defaultValue;
    }

    public double get(String key, double defaultValue) {
        return this.has(key) ? Double.parseDouble(this.mMemoryCache.get(key).toString()) : defaultValue;
    }

    public float get(String key, float defaultValue) {
        return this.has(key) ? Float.parseFloat(this.mMemoryCache.get(key).toString()) : defaultValue;
    }

    public long get(String key, long defaultValue) {
        return this.has(key) ? Long.parseLong(this.mMemoryCache.get(key).toString()) : defaultValue;
    }

    public void clear() {
        this.mMemoryCache.clear();
        this.mSingleThreadExecutor.execute(this.mUpdateDiskRunnable);
    }

    public void clearSync() {
        this.mMemoryCache.clear();
        this.mUpdateDiskRunnable.run();
    }

    public void destroy() {
        sStores.remove(this.mStoreName);
        this.mMemoryCache.clear();
    }

    public Set<String> keys() {
        return this.mMemoryCache.keySet();
    }

    public void remove(String key) {
        this.mMemoryCache.remove(key);
        this.mSingleThreadExecutor.submit(this.mUpdateDiskRunnable);
    }

    public void refresh() {
        this.mMemoryCache.clear();
        this.readFromDisk();
    }

    public boolean hasChanged() {
        return this.mLastModifiedTime != this.mPathToStore.lastModified();
    }

    protected void initialise() {
        this.readFromDisk();
    }

    private synchronized void readFromDisk() {
        String cache = FileManager.readCompressedFile(this.mPathToStore);
        this.mLastModifiedTime = this.mPathToStore.lastModified();
        try {
            JSONObject json = new JSONObject(cache);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.mMemoryCache.put(key, json.get(key));
            }
            this.onReadCompleted();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void onReadCompleted() {
    }

    protected void onWriteCompleted() {
    }
}

