/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.github.bijoysingh.starter.util.TextUtils;

public class IntentUtils {
    public static <T extends Activity> void startActivity(Context context, Class<T> activity) {
        Intent intent = new Intent(context, activity);
        context.startActivity(intent);
    }

    public static void openAppPlayStore(Context context) {
        String appPackageName = context.getPackageName();
        IntentUtils.openAppPlayStore(context, appPackageName);
    }

    public static void openAppPlayStore(Context context, String appPackageName) {
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + appPackageName))));
        }
        catch (ActivityNotFoundException anfe) {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + appPackageName))));
        }
    }

    public static class ShareBuilder {
        private Context context;
        private String subject;
        private String text;
        private String chooserText = "Share using...";

        public ShareBuilder(Context context) {
            this.context = context;
        }

        public ShareBuilder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public ShareBuilder setText(String text) {
            this.text = text;
            return this;
        }

        public ShareBuilder setChooserText(String chooserText) {
            this.chooserText = chooserText;
            return this;
        }

        public void share() {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            if (!TextUtils.isNullOrEmpty(this.subject)) {
                sharingIntent.putExtra("android.intent.extra.SUBJECT", this.subject);
            }
            if (!TextUtils.isNullOrEmpty(this.text)) {
                sharingIntent.putExtra("android.intent.extra.TEXT", this.text);
            }
            this.context.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share using..."));
        }
    }
}

