/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SimpleThreadExecutor {
    private ExecutorService mThreadPool;
    private List<Runnable> mRunnable;

    public SimpleThreadExecutor() {
        this.mThreadPool = Executors.newSingleThreadExecutor();
        this.mRunnable = new ArrayList<Runnable>();
    }

    public SimpleThreadExecutor(int numberThreads) {
        this.mThreadPool = Executors.newFixedThreadPool(numberThreads);
        this.mRunnable = new ArrayList<Runnable>();
    }

    public SimpleThreadExecutor addRunnable(Runnable runnable) {
        this.mRunnable.add(runnable);
        return this;
    }

    public SimpleThreadExecutor executeNow(Runnable runnable) {
        if (this.mThreadPool != null) {
            this.mThreadPool.execute(runnable);
        }
        return this;
    }

    public void execute() {
        if (this.mThreadPool != null && this.mRunnable != null) {
            for (Runnable runnable : this.mRunnable) {
                this.mThreadPool.execute(runnable);
            }
        }
    }

    public <T> Future<T> submit(Callable<T> callable) {
        if (this.mThreadPool != null) {
            return this.mThreadPool.submit(callable);
        }
        return null;
    }

    public ExecutorService getThreadPool() {
        return this.mThreadPool;
    }

    public static void execute(Runnable runnable) {
        SimpleThreadExecutor executor = new SimpleThreadExecutor();
        executor.executeNow(runnable);
    }
}

