/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import android.util.Log;
import com.github.bijoysingh.starter.async.SimpleThreadExecutor;
import com.github.bijoysingh.starter.json.SafeJson;
import com.github.bijoysingh.starter.util.FileManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.json.JSONException;

public class DataStore {
    private static final String FILENAME_PREFIX = "StorageManager.";
    private static final String FILENAME_SUFFIX = ".txt";
    private static SafeJson data;
    private static SimpleThreadExecutor executor;
    private Context context;
    private boolean writeSynchronous;

    public static DataStore get(Context context) {
        return new DataStore(context);
    }

    public static Future<DataStore> getFuture(final Context context) {
        executor = executor == null ? new SimpleThreadExecutor() : executor;
        return executor.submit(new Callable<DataStore>(){

            @Override
            public DataStore call() throws Exception {
                return new DataStore(context);
            }
        });
    }

    public void setWriteSynchronous(boolean writeSynchronous) {
        this.writeSynchronous = writeSynchronous;
    }

    private DataStore(Context context) {
        this.context = context;
        executor = executor == null ? new SimpleThreadExecutor() : executor;
        this.maybeRefresh();
    }

    protected String getFilename() {
        return FILENAME_PREFIX + this.context.getPackageName() + FILENAME_SUFFIX;
    }

    public boolean has(String key) {
        return data.has(key);
    }

    public void put(String key, boolean value) {
        this.putSafe(key, value);
    }

    public void put(String key, int value) {
        this.putSafe(key, value);
    }

    public void put(String key, String value) {
        this.putSafe(key, value);
    }

    public void put(String key, double value) {
        this.putSafe(key, value);
    }

    public void put(String key, float value) {
        this.putSafe(key, Float.valueOf(value));
    }

    public void put(String key, long value) {
        this.putSafe(key, value);
    }

    public boolean get(String key, boolean defaultValue) {
        return data.getBoolean(key, defaultValue);
    }

    public int get(String key, int defaultValue) {
        return data.getInt(key, defaultValue);
    }

    public String get(String key, String defaultValue) {
        return data.getString(key, defaultValue);
    }

    public double get(String key, double defaultValue) {
        return data.getDouble(key, defaultValue);
    }

    public float get(String key, float defaultValue) {
        return (float)data.getDouble(key, defaultValue);
    }

    public long get(String key, long defaultValue) {
        return data.getLong(key, defaultValue);
    }

    private void putSafe(String key, Object value) {
        try {
            data.put(key, value);
            this.write();
        }
        catch (JSONException exception) {
            Log.e((String)DataStore.class.getSimpleName(), (String)"Put Failed", (Throwable)exception);
        }
    }

    public DataStore refresh() {
        String content = FileManager.read(this.context, this.getFilename());
        try {
            data = new SafeJson(content);
        }
        catch (JSONException exception) {
            data = new SafeJson();
        }
        return this;
    }

    public void empty() {
        Iterator keyIterator = data.keys();
        HashSet keys = new HashSet();
        while (keyIterator.hasNext()) {
            keys.add(keyIterator.next());
        }
        for (String key : keys) {
            data.remove(key);
        }
        this.write();
    }

    public static void reset() {
        executor = null;
        data = null;
    }

    private void maybeRefresh() {
        if (data == null) {
            this.refresh();
        }
    }

    private void write() {
        final String dataState = data.toString();
        if (this.writeSynchronous) {
            this.flush(dataState);
            return;
        }
        executor.executeNow(new Runnable(){

            @Override
            public void run() {
                DataStore.this.flush(dataState);
            }
        });
    }

    private void flush(String data) {
        FileManager.write(this.context, this.getFilename(), data);
    }
}

