/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;

public class TextUtils {
    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static void copyToClipboard(Context context, String clipText) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"simple text", (CharSequence)clipText);
        clipboard.setPrimaryClip(clip);
    }

    public static class ShareBuilder {
        private Context context;
        private String subject;
        private String text;
        private String chooserText = "Share using...";

        public ShareBuilder(Context context) {
            this.context = context;
        }

        public ShareBuilder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public ShareBuilder setText(String text) {
            this.text = text;
            return this;
        }

        public ShareBuilder setChooserText(String chooserText) {
            this.chooserText = chooserText;
            return this;
        }

        public void share() {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            if (!TextUtils.isNullOrEmpty(this.subject)) {
                sharingIntent.putExtra("android.intent.extra.SUBJECT", this.subject);
            }
            if (!TextUtils.isNullOrEmpty(this.text)) {
                sharingIntent.putExtra("android.intent.extra.TEXT", this.text);
            }
            this.context.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)"Share using..."));
        }
    }
}

