/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.database;

import android.content.Context;
import com.github.bijoysingh.starter.util.FileManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Database<M> {
    protected Context context;
    protected static final String MODELS_KEY = "models";

    public Database(Context context) {
        this.context = context;
    }

    protected abstract String getDatabaseFilename();

    protected abstract void setCacheList(List<M> var1);

    protected abstract List<M> getCacheList();

    protected abstract String getId(M var1);

    protected abstract JSONObject serialise(M var1);

    protected abstract M deSerialise(JSONObject var1);

    public void addOrUpdate(M object) {
        List<M> models = this.getList();
        boolean replaceModel = false;
        int index = 0;
        for (M model : models) {
            if (this.getId(model).equals(this.getId(object))) {
                replaceModel = true;
                break;
            }
            ++index;
        }
        if (replaceModel) {
            models.set(index, object);
        } else {
            models.add(object);
        }
        this.setCacheList(models);
        this.setAllIntoFile(models);
    }

    public void delete(M object) {
        List<M> models = this.getList();
        boolean replaceModel = false;
        int index = 0;
        for (M model : models) {
            if (this.getId(model).equals(this.getId(object))) {
                replaceModel = true;
                break;
            }
            ++index;
        }
        if (replaceModel) {
            models.remove(index);
            this.setCacheList(models);
            this.setAllIntoFile(models);
        }
    }

    public void deleteAll() {
        ArrayList models = new ArrayList();
        this.setCacheList(models);
        this.setAllIntoFile(models);
    }

    public M get(String id) {
        for (M model : this.getList()) {
            if (!this.getId(model).equals(id)) continue;
            return model;
        }
        return null;
    }

    public List<M> getAll() {
        return this.getList();
    }

    private List<M> getList() {
        List<M> list = this.getCacheList();
        if (list == null) {
            list = this.getAllFromFile();
            this.setCacheList(list);
        }
        return list;
    }

    private List<M> getAllFromFile() {
        ArrayList<M> models = new ArrayList<M>();
        String read = FileManager.read(this.context, this.getDatabaseFilename());
        try {
            JSONObject json = new JSONObject(read);
            JSONArray array = json.getJSONArray(MODELS_KEY);
            for (int index = 0; index < array.length(); ++index) {
                try {
                    models.add(this.deSerialise(array.getJSONObject(index)));
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return models;
    }

    private void setAllIntoFile(List<M> models) {
        JSONArray array = new JSONArray();
        for (M model : models) {
            array.put((Object)this.serialise(model));
        }
        HashMap<String, JSONArray> cache = new HashMap<String, JSONArray>();
        cache.put(MODELS_KEY, array);
        FileManager.writeAsync(this.context, this.getDatabaseFilename(), new JSONObject(cache).toString());
    }
}

