/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.prefs;

import android.content.Context;
import android.util.Log;
import com.github.bijoysingh.starter.json.SafeJson;
import com.github.bijoysingh.starter.util.FileManager;
import org.json.JSONException;

public class StorageManager {
    private Context context;
    private static SafeJson data;
    private boolean isAsync;

    public StorageManager(Context context) {
        this.context = context;
        this.isAsync = false;
        this.maybeRefresh();
    }

    protected String getFilename() {
        return "StorageManager." + this.context.getPackageName() + ".txt";
    }

    public boolean has(String key) {
        return data.has(key);
    }

    public void put(String key, boolean value) {
        this.putSafe(key, value);
    }

    public void put(String key, int value) {
        this.putSafe(key, value);
    }

    public void put(String key, String value) {
        this.putSafe(key, value);
    }

    public void put(String key, double value) {
        this.putSafe(key, value);
    }

    public void put(String key, float value) {
        this.putSafe(key, Float.valueOf(value));
    }

    public void put(String key, long value) {
        this.putSafe(key, value);
    }

    public boolean get(String key, boolean defaultValue) {
        return data.getBoolean(key, defaultValue);
    }

    public int get(String key, int defaultValue) {
        return data.getInt(key, defaultValue);
    }

    public String get(String key, String defaultValue) {
        return data.getString(key, defaultValue);
    }

    public double get(String key, double defaultValue) {
        return data.getDouble(key, defaultValue);
    }

    public float get(String key, float defaultValue) {
        return (float)data.getDouble(key, defaultValue);
    }

    public long get(String key, long defaultValue) {
        return data.getLong(key, defaultValue);
    }

    private void putSafe(String key, Object value) {
        try {
            data.put(key, value);
            this.write();
        }
        catch (JSONException exception) {
            Log.e((String)StorageManager.class.getSimpleName(), (String)"Put Failed", (Throwable)exception);
        }
    }

    public StorageManager refresh() {
        String content = FileManager.read(this.context, this.getFilename());
        try {
            data = new SafeJson(content);
        }
        catch (JSONException exception) {
            data = new SafeJson();
        }
        return this;
    }

    private StorageManager maybeRefresh() {
        if (data == null) {
            return this.refresh();
        }
        return this;
    }

    private StorageManager setIsAsync(boolean isAsync) {
        this.isAsync = isAsync;
        return this;
    }

    private void write() {
        if (this.isAsync) {
            FileManager.writeAsync(this.context, this.getFilename(), data.toString());
            return;
        }
        FileManager.write(this.context, this.getFilename(), data.toString());
    }
}

