/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import com.github.bijoysingh.starter.item.TimestampItem;
import java.util.Calendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampManager {
    public static String SPACE = " ";
    public static String PM = "p.m.";
    public static String AM = "a.m.";
    public static String MIDNIGHT = "Midnight";
    public static String NOON = "Noon";
    public static String COLON = ":";

    private static DateTime getDateTimeObject(String timestamp) {
        try {
            return new DateTime((Object)timestamp);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static TimestampItem createTimestampItem(String timestamp, DateTime dateTime) {
        String MM = dateTime.monthOfYear().getAsString();
        String MMMM = dateTime.monthOfYear().getAsText();
        String dd = dateTime.dayOfMonth().getAsText();
        String hh = dateTime.hourOfDay().getAsText();
        String mm = dateTime.minuteOfHour().getAsText();
        String yyyy = dateTime.year().getAsText();
        String date = dd + SPACE + MMMM + SPACE + yyyy;
        String time = TimestampManager.get12hrFormattedTime(hh, mm);
        Calendar calender = TimestampManager.getCalendar(yyyy, MM, dd, hh, mm);
        return new TimestampItem(timestamp, time, date, calender);
    }

    public static TimestampItem getTimestampItem(String timestamp) {
        return TimestampManager.getTimestampItem(timestamp, DateTimeZone.UTC, 0, 0);
    }

    public static TimestampItem getTimestampItem(String timestamp, Integer hour, Integer minutes) {
        return TimestampManager.getTimestampItem(timestamp, DateTimeZone.UTC, hour, minutes);
    }

    public static TimestampItem getTimestampItem(String timestamp, DateTimeZone dateTimeZone, Integer hour, Integer minutes) {
        DateTime dateTime = TimestampManager.getDateTimeObject(timestamp);
        if (dateTime == null) {
            return new TimestampItem(timestamp, null, null, Calendar.getInstance());
        }
        dateTime = dateTime.toDateTime(dateTimeZone);
        dateTime = dateTime.plusHours(5).plusMinutes(30);
        return TimestampManager.createTimestampItem(timestamp, dateTime);
    }

    public static String get12hrFormattedTime(String hh, String mm) {
        Integer hr = Integer.parseInt(hh);
        Integer min = Integer.parseInt(mm);
        if (mm.length() == 1) {
            mm = "0" + mm;
        }
        if (hr == 0 && min == 0) {
            return MIDNIGHT;
        }
        if (hr == 0) {
            return 12 + COLON + mm + SPACE + AM;
        }
        if (hr < 12) {
            return hh + COLON + mm + SPACE + AM;
        }
        if (hr == 12 && min == 0) {
            return NOON;
        }
        if (hr == 12) {
            return hr + COLON + mm + SPACE + PM;
        }
        return hr - 12 + COLON + mm + SPACE + PM;
    }

    private static Calendar getCalendar(String yyyy, String MM, String dd, String hh, String mm) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(yyyy), Integer.parseInt(MM) - 1, Integer.parseInt(dd), Integer.parseInt(hh), Integer.parseInt(mm));
        return calendar;
    }
}

