/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.bijoysingh.starter.recyclerview.RVHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class RVAdapter<T, U extends RVHolder<T>>
extends RecyclerView.Adapter<U> {
    protected Context context;
    protected Integer layout;
    protected List<T> contents;
    protected Class<U> type;

    public RVAdapter(Context context, Integer layout, Class<U> type) {
        this.context = context;
        this.layout = layout;
        this.type = type;
        this.contents = new ArrayList<T>();
    }

    public List<T> getItems() {
        return this.contents;
    }

    public void setItems(List<T> list) {
        this.contents = list;
    }

    public void addItem(T item, int position) {
        this.contents.add(position, item);
        this.notifyItemInserted(position);
    }

    public void updateItem(T item, int position) {
        this.contents.remove(position);
        this.contents.add(position, item);
        this.notifyItemChanged(position);
    }

    public void addItem(T item) {
        this.contents.add(item);
        this.notifyItemInserted(this.contents.size() - 1);
    }

    public void addItems(List<T> items) {
        this.contents.addAll(items);
        this.notifyItemRangeInserted(this.contents.size() - items.size() - 1, items.size());
    }

    public void removeItem(T item) {
        int position = this.contents.indexOf(item);
        if (position != -1) {
            this.removeItem(position);
        }
    }

    public void removeItem(int position) {
        this.contents.remove(position);
        this.notifyItemRemoved(position);
    }

    public U onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.layout.intValue(), parent, false);
        try {
            return (U)((Object)((RVHolder)((Object)this.type.getConstructor(Context.class, View.class).newInstance(this.context, v))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onBindViewHolder(U holder, int position) {
        T data = this.getItems().get(position);
        ((RVHolder)((Object)holder)).populate(data);
    }

    public int getItemCount() {
        return this.getItems().size();
    }
}

