/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.bijoysingh.starter.recyclerview.RVHolder;
import java.util.List;

public abstract class RVAdapter<T, U extends RVHolder<T>>
extends RecyclerView.Adapter<U> {
    protected Context context;
    protected Integer layout;
    protected List<T> contents;
    protected Class<U> type;

    public RVAdapter(Context context, Integer layout, Class<U> type) {
        this.context = context;
        this.layout = layout;
        this.type = type;
    }

    public abstract List<T> getValues();

    public U onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(this.layout.intValue(), parent, false);
        try {
            return (U)((Object)((RVHolder)((Object)this.type.getConstructor(Context.class, View.class).newInstance(this.context, v))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onBindViewHolder(U holder, int position) {
        T data = this.getValues().get(position);
        ((RVHolder)((Object)holder)).populate(data);
    }

    public int getItemCount() {
        return this.getValues().size();
    }
}

