/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.images;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageManager {
    public static final Integer PICK_IMAGE_REQUEST = 2139;
    Activity activity;

    public ImageManager(Activity activity) {
        this.activity = activity;
    }

    public static String toBase64(Bitmap bmp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        byte[] imageBytes = baos.toByteArray();
        return Base64.encodeToString((byte[])imageBytes, (int)0);
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, Integer width, Integer height) {
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
    }

    public static Bitmap getScaledBitmap(Bitmap bitmap, float scale) {
        Integer originalHeight = bitmap.getHeight();
        Integer originalWidth = bitmap.getWidth();
        Integer requiredHeight = Math.round((float)originalHeight.intValue() * scale);
        Integer requiredWidth = Math.round((float)originalWidth.intValue() * scale);
        return ImageManager.resizeBitmap(bitmap, requiredWidth, requiredHeight);
    }

    public static Bitmap getScaledBitmapWithHeight(Bitmap bitmap, Integer height) {
        Integer originalHeight = bitmap.getHeight();
        float scale = (float)height.intValue() * 1.0f / (float)originalHeight.intValue() * 1.0f;
        return ImageManager.getScaledBitmap(bitmap, scale);
    }

    public static Bitmap getScaledBitmapWithWidth(Bitmap bitmap, Integer width) {
        Integer originalWidth = bitmap.getWidth();
        float scale = (float)width.intValue() * 1.0f / (float)originalWidth.intValue() * 1.0f;
        return ImageManager.getScaledBitmap(bitmap, scale);
    }

    public void showFileChooser(String chooserTitle) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        this.activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)chooserTitle), PICK_IMAGE_REQUEST.intValue());
    }

    public void showFileChooser() {
        this.showFileChooser("Select Picture");
    }

    public Bitmap handleResponse(Integer requestCode, Integer resultCode, Intent data) throws Exception {
        if (requestCode.equals(PICK_IMAGE_REQUEST) && resultCode.equals(-1) && data != null) {
            Uri imageUri = data.getData();
            InputStream imageStream = this.activity.getContentResolver().openInputStream(imageUri);
            return BitmapFactory.decodeStream((InputStream)imageStream);
        }
        return null;
    }
}

