/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Parallel<I, O> {
    private int numberOfThreads;
    private ParallelExecutionListener<I, O> listener;

    public Parallel() {
        this.numberOfThreads = Runtime.getRuntime().availableProcessors();
    }

    public Parallel(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public Parallel(ParallelExecutionListener<I, O> listener) {
        this.listener = listener;
    }

    public Parallel(int numberOfThreads, ParallelExecutionListener<I, O> listener) {
        this.numberOfThreads = numberOfThreads;
        this.listener = listener;
    }

    public List<O> For(List<I> inputs) throws Exception {
        ExecutorService service = Executors.newFixedThreadPool((int)((double)this.numberOfThreads * 1.25));
        ArrayList futures = new ArrayList();
        for (final I input : inputs) {
            Callable callable = new Callable<O>(){

                @Override
                public O call() throws Exception {
                    return Parallel.this.listener == null ? null : (Object)Parallel.this.listener.onExecution(input);
                }
            };
            futures.add(service.submit(callable));
        }
        service.shutdown();
        ArrayList outputs = new ArrayList();
        for (Future future : futures) {
            outputs.add(future.get());
        }
        return outputs;
    }

    public static interface ParallelExecutionListener<I, O> {
        public O onExecution(I var1);
    }
}

