/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.item;

import android.support.annotation.Nullable;
import android.util.Pair;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimestampItem {
    private String timestamp;
    private String time;
    private String date;
    private String dateTime;
    private Calendar calender;

    private TimestampItem(String timestamp, @Nullable String time, @Nullable String date, @Nullable String dateTime, Calendar calender) {
        this.timestamp = timestamp;
        this.time = time;
        this.date = date;
        this.dateTime = dateTime;
        this.calender = calender;
    }

    public String getTime() {
        return this.time == null ? this.timestamp : this.time;
    }

    public String getDate() {
        return this.date == null ? this.timestamp : this.date;
    }

    public String getDateTime() {
        return this.dateTime == null ? this.timestamp : this.dateTime;
    }

    public Calendar getCalender() {
        return this.calender;
    }

    public String getCompressedDateTime() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(6) == this.calender.get(6) && calendar.get(1) == this.calender.get(1)) {
            return this.time;
        }
        return this.date;
    }

    public static Pair<Integer, Integer> getTimezoneOffset() {
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        int mGMTOffset = timeZone.getRawOffset();
        Integer minutes = mGMTOffset / 60000;
        Integer hours = minutes / 60;
        minutes = minutes - hours * 60;
        return new Pair((Object)hours, (Object)minutes);
    }

    public static class Builder {
        private String timestamp;
        private Integer hours;
        private Integer minutes;
        public String timeFormat;
        public String dateFormat;
        public String dateTimeFormat;

        public Builder(String timestamp) {
            this.timestamp = timestamp;
            this.hours = 0;
            this.minutes = 0;
            this.timeFormat = "hh:mm aa";
            this.dateFormat = "dd MMMM yyyy";
            this.dateTimeFormat = "hh:mm aa, dd MMMM yyyy";
        }

        public Builder setTimezone(Integer hours, Integer minutes) {
            this.hours = hours;
            this.minutes = minutes;
            return this;
        }

        public Builder setDeviceTimezone() {
            Pair<Integer, Integer> deviceTimezone = TimestampItem.getTimezoneOffset();
            return this.setTimezone((Integer)deviceTimezone.first, (Integer)deviceTimezone.second);
        }

        public Builder setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        private DateTime getDateTimeObject(String timestamp) {
            try {
                return new DateTime((Object)timestamp);
            }
            catch (Exception e) {
                return null;
            }
        }

        public TimestampItem build() {
            DateTime dateTime = this.getDateTimeObject(this.timestamp);
            if (dateTime == null) {
                return new TimestampItem(this.timestamp, null, null, null, Calendar.getInstance());
            }
            dateTime = dateTime.toDateTime(DateTimeZone.UTC);
            dateTime = dateTime.plusHours(this.hours.intValue()).plusMinutes(this.minutes.intValue());
            Calendar calendar = dateTime.toCalendar(Locale.getDefault());
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.dateFormat, Locale.getDefault());
            String date = dateFormatter.format(calendar.getTime());
            SimpleDateFormat timeFormatter = new SimpleDateFormat(this.timeFormat, Locale.getDefault());
            String time = timeFormatter.format(calendar.getTime());
            SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(this.dateTimeFormat, Locale.getDefault());
            String dateTimeString = dateTimeFormatter.format(calendar.getTime());
            return new TimestampItem(this.timestamp, time, date, dateTimeString, calendar);
        }
    }
}

