/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import android.util.Log;
import java.util.HashMap;
import org.json.JSONObject;

public class SimpleProfiler {
    private String tag;
    private int logMode;
    private long startMillis;

    public SimpleProfiler(String tag, int logMode) {
        this.tag = tag;
        this.logMode = logMode;
    }

    public void start() {
        this.startMillis = System.currentTimeMillis();
    }

    public void capture() {
        this.logEvent("null", System.currentTimeMillis());
    }

    public void capture(String tag) {
        this.logEvent(tag, System.currentTimeMillis());
    }

    private void logEvent(String event, long millis) {
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("event", event);
        log.put("system_time(ms)", millis);
        log.put("since_start(ms)", millis - this.startMillis);
        Log.println((int)this.logMode, (String)this.tag, (String)new JSONObject(log).toString());
    }

    public static class Builder {
        private String tag = SimpleProfiler.class.getSimpleName();
        private int logMode = 3;

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setLogMode(int logMode) {
            this.logMode = logMode;
            return this;
        }

        public SimpleProfiler build() {
            return new SimpleProfiler(this.tag, this.logMode);
        }
    }
}

