/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.database;

import com.github.bijoysingh.starter.database.DBColumn;
import java.lang.reflect.Field;

public class DatabaseColumn {
    public String fieldName;
    public DBColumn.Type fieldType;
    public Boolean primaryKey;
    public Boolean autoIncrement;
    public Boolean unique;
    public Field field;

    public DatabaseColumn(DBColumn column) {
        this.fieldName = column.fieldName();
        this.fieldType = column.fieldType();
        this.primaryKey = column.primaryKey();
        this.autoIncrement = column.autoIncrement();
        this.unique = column.unique();
    }

    public DatabaseColumn(String fieldName, DBColumn.Type fieldType, Boolean primaryKey, Boolean autoIncrement, Boolean unique) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.primaryKey = primaryKey;
        this.autoIncrement = autoIncrement;
        this.unique = unique;
    }

    public static DBColumn.Type getType(Class classType) {
        if (classType.equals(Integer.class) || classType.equals(Short.class) || classType.equals(Long.class)) {
            return DBColumn.Type.INTEGER;
        }
        if (classType.equals(String.class) || classType.equals(Character.class) || classType.equals(CharSequence.class)) {
            return DBColumn.Type.TEXT;
        }
        if (classType.equals(Double.class) || classType.equals(Float.class)) {
            return DBColumn.Type.REAL;
        }
        return DBColumn.Type.TEXT;
    }

    public String getCreateQuery() {
        String sql = this.fieldName + " " + this.fieldType.toString();
        if (this.primaryKey.booleanValue()) {
            sql = sql + " PRIMARY KEY";
        }
        if (this.autoIncrement.booleanValue()) {
            sql = sql + " AUTOINCREMENT";
        }
        if (this.unique.booleanValue()) {
            sql = sql + " UNIQUE";
        }
        return sql;
    }
}

