/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.json;

import com.github.bijoysingh.starter.json.JsonField;
import com.github.bijoysingh.starter.json.JsonModel;
import com.github.bijoysingh.starter.json.JsonModelException;
import java.lang.reflect.Field;
import org.json.JSONObject;

public class JsonFieldItem {
    public JsonField.Type type;
    public String fieldName;
    public Field field;
    public Class jsonField;
    public Boolean optional;

    public JsonFieldItem(JsonField annotation) {
        this.fieldName = annotation.field();
        this.type = annotation.type();
        this.jsonField = annotation.jsonModel();
        this.optional = annotation.isOptional();
    }

    public JsonFieldItem setFieldName(String fieldName) {
        if (this.fieldName.isEmpty()) {
            this.fieldName = fieldName;
        }
        return this;
    }

    public JsonFieldItem setFieldType(Class classType) {
        if (this.type == JsonField.Type.AUTO) {
            this.type = JsonFieldItem.getType(classType);
            if (this.type == JsonField.Type.UNKNOWN) {
                throw new JsonModelException(JsonModelException.ErrorResponse.UNKNOWN_AUTO.toString());
            }
        }
        if (this.type.equals((Object)JsonField.Type.JSON_MODEL) && !JsonModel.class.isAssignableFrom(classType)) {
            throw new JsonModelException(JsonModelException.ErrorResponse.JSON_FIELD_WRONG_CLASS.toString());
        }
        return this;
    }

    public JsonFieldItem setField(Field field) {
        this.field = field;
        return this;
    }

    private static JsonField.Type getType(Class classType) {
        if (classType.equals(Integer.class) || classType.equals(Short.class) || classType.equals(Long.class)) {
            return JsonField.Type.INTEGER;
        }
        if (classType.equals(String.class) || classType.equals(CharSequence.class)) {
            return JsonField.Type.STRING;
        }
        if (classType.equals(Double.class) || classType.equals(Float.class)) {
            return JsonField.Type.REAL;
        }
        if (classType.equals(Boolean.class)) {
            return JsonField.Type.BOOLEAN;
        }
        if (classType.equals(JSONObject.class)) {
            return JsonField.Type.JSON;
        }
        return JsonField.Type.UNKNOWN;
    }
}

