/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateFormatter {
    private static String getDefaultFormat() {
        return Formats.HH_MM_A_DD_MMMM_YYYY.getFormat();
    }

    public static String getToday() {
        return DateFormatter.getToday(DateFormatter.getDefaultFormat());
    }

    public static String getToday(String format) {
        return DateFormatter.getDate(format, Calendar.getInstance());
    }

    public static String getDate(Calendar calendar) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), calendar.getTime());
    }

    public static String getDate(String format, Calendar calendar) {
        return DateFormatter.getDate(format, calendar.getTime());
    }

    public static String getDate(Date date) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), date, Locale.getDefault());
    }

    public static String getDate(String format, Date date) {
        return DateFormatter.getDate(format, date, Locale.getDefault());
    }

    public static String getDate(Calendar calendar, Locale locale) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), calendar.getTime(), locale);
    }

    public static String getDate(String format, Calendar calendar, Locale locale) {
        return DateFormatter.getDate(format, calendar.getTime(), locale);
    }

    public static String getDate(Date date, Locale locale) {
        return DateFormatter.getDate(DateFormatter.getDefaultFormat(), date, locale);
    }

    public static String getDate(String format, Date date, Locale locale) {
        SimpleDateFormat timeFormatter = new SimpleDateFormat(format, locale);
        return timeFormatter.format(date);
    }

    public static enum Formats {
        DD_MM_YYYY("dd mm yyyy"),
        DD_MMM_YYYY("dd mmm yyyy"),
        DD_MMMM_YYYY("dd mmmm yyyy"),
        HH_MM_SS("HH:MM.SS"),
        HH_MM("HH:MM"),
        HH_MM_A("hh:MM a"),
        HH_MM_SS_A("hh:MM.SS a"),
        HH_MM_DD_MM_YYYY("HH:MM, dd mm yyyy"),
        HH_MM_DD_MMM_YYYY("HH:MM, dd mmm yyyy"),
        HH_MM_DD_MMMM_YYYY("HH:MM, dd mmmm yyyy"),
        HH_MM_A_DD_MM_YYYY("hh:MM a, dd mm yyyy"),
        HH_MM_A_DD_MMM_YYYY("hh:MM a, dd mmm yyyy"),
        HH_MM_A_DD_MMMM_YYYY("hh:MM a, dd mmmm yyyy");

        private String format;

        private Formats(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

