/*
 * Decompiled with CFR 0.152.
 */
package com.github.bijoysingh.starter.json;

import android.util.Log;
import com.github.bijoysingh.starter.json.JsonField;
import com.github.bijoysingh.starter.json.JsonFieldItem;
import com.github.bijoysingh.starter.json.JsonModelException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonModel {
    List<JsonFieldItem> jsonFields;

    private JsonModel() {
    }

    public JsonModel(String source) throws Exception {
        this(new JSONObject(source));
    }

    public JsonModel(JSONObject json) throws Exception {
        this.setFields();
        for (JsonFieldItem jsonField : this.jsonFields) {
            try {
                if (jsonField.type.equals((Object)JsonField.Type.INTEGER)) {
                    jsonField.field.set(this, json.getInt(jsonField.fieldName));
                    continue;
                }
                if (jsonField.type.equals((Object)JsonField.Type.REAL)) {
                    jsonField.field.set(this, json.getDouble(jsonField.fieldName));
                    continue;
                }
                if (jsonField.type.equals((Object)JsonField.Type.BOOLEAN)) {
                    jsonField.field.set(this, json.getBoolean(jsonField.fieldName));
                    continue;
                }
                if (jsonField.type.equals((Object)JsonField.Type.STRING)) {
                    jsonField.field.set(this, json.getString(jsonField.fieldName));
                    continue;
                }
                if (jsonField.type.equals((Object)JsonField.Type.JSON)) {
                    jsonField.field.set(this, json.getJSONObject(jsonField.fieldName));
                    continue;
                }
                if (!jsonField.type.equals((Object)JsonField.Type.JSON_MODEL)) continue;
                jsonField.field.set(this, jsonField.jsonField.getConstructor(JSONObject.class).newInstance(json.getJSONObject(jsonField.fieldName)));
            }
            catch (JSONException exception) {
                if (jsonField.optional.booleanValue()) {
                    Log.e((String)JsonModel.class.getSimpleName(), (String)exception.getMessage(), (Throwable)exception);
                    continue;
                }
                throw exception;
            }
        }
    }

    public JSONObject serialize() throws Exception {
        this.setFields();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (JsonFieldItem field : this.jsonFields) {
            if (field.type.equals((Object)JsonField.Type.JSON_MODEL)) {
                values.put(field.fieldName, ((JsonModel)field.field.get(this)).serialize());
                continue;
            }
            values.put(field.fieldName, field.field.get(this));
        }
        return new JSONObject(values);
    }

    private void setFields() throws JsonModelException {
        Field[] classFields;
        if (this.jsonFields != null) {
            return;
        }
        this.jsonFields = new ArrayList<JsonFieldItem>();
        for (Field field : classFields = this.getClass().getDeclaredFields()) {
            JsonField annotation = field.getAnnotation(JsonField.class);
            if (annotation == null) continue;
            JsonFieldItem item = new JsonFieldItem(annotation).setFieldName(field.getName()).setFieldType(field.getType()).setField(field);
            this.jsonFields.add(item);
        }
    }
}

