/*
 * Decompiled with CFR 0.152.
 */
package com.acutecoder.pdf.ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.SwitchCompat;
import com.acutecoder.pdf.PdfDocumentProperties;
import com.acutecoder.pdf.PdfListener;
import com.acutecoder.pdf.PdfViewer;
import com.acutecoder.pdf.ui.ColorItemGrid;
import com.acutecoder.pdf.ui.ColorItemView;
import com.acutecoder.pdf.ui.ExtensionsKt;
import com.acutecoder.pdf.ui.PdfToolBarKt;
import com.acutecoder.pdf.ui.PdfToolBarMenuItem;
import com.acutecoder.pdf.ui.R;
import com.acutecoder.pdf.ui.Zoom;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0080\u0001\u001a\u00020\u0015H\u0014J\u0011\u0010\u0081\u0001\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u001b\u0010\u0082\u0001\u001a\u00020\u00152\u0006\u00104\u001a\u00020&2\n\b\u0002\u0010\u0083\u0001\u001a\u00030\u0084\u0001J\u000f\u0010\u0085\u0001\u001a\u00020\u00152\u0006\u0010<\u001a\u00020&J\b\u0010\u0086\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0087\u0001\u001a\u00020\u00152\b\u0010\u0088\u0001\u001a\u00030\u0084\u0001J\u0011\u0010\u0089\u0001\u001a\u00020\u00152\b\u0010\u0088\u0001\u001a\u00030\u0084\u0001J\b\u0010\u008a\u0001\u001a\u00030\u0084\u0001J\u0013\u0010\u008b\u0001\u001a\u00020\u00152\b\u0010\u0088\u0001\u001a\u00030\u0084\u0001H\u0007J\b\u0010\u008c\u0001\u001a\u00030\u0084\u0001J\u0013\u0010\u008d\u0001\u001a\u00020\u00152\b\u0010\u0088\u0001\u001a\u00030\u0084\u0001H\u0007J\b\u0010\u008e\u0001\u001a\u00030\u0084\u0001J\u0013\u0010\u008f\u0001\u001a\u00020\u00152\b\u0010\u0088\u0001\u001a\u00030\u0084\u0001H\u0007J\b\u0010\u0090\u0001\u001a\u00030\u0084\u0001J\u001d\u0010\u0091\u0001\u001a\u00020\u00152\b\u0010\u0092\u0001\u001a\u00030\u0084\u00012\b\u0010\u0093\u0001\u001a\u00030\u0084\u0001H\u0003J\u0013\u0010\u0094\u0001\u001a\u00020\u00152\b\b\u0001\u0010*\u001a\u00020\u0007H\u0002J\t\u0010\u0095\u0001\u001a\u00020\u0015H\u0003J\t\u0010\u0096\u0001\u001a\u00020\u0015H\u0002J\u0014\u0010\u0097\u0001\u001a\u00030\u0084\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0014J\u0013\u0010\u009a\u0001\u001a\u00030\u009b\u00012\u0007\u0010\u009c\u0001\u001a\u00020(H\u0014J=\u0010\u009d\u0001\u001a\u00030\u009b\u00012\b\u0010\u009e\u0001\u001a\u00030\u009b\u00012'\b\u0002\u0010\u009f\u0001\u001a \u0012\u0015\u0012\u00130\u00a0\u0001\u00a2\u0006\r\b3\u0012\t\b4\u0012\u0005\b\b(\u00a1\u0001\u0012\u0005\u0012\u00030\u0084\u00010\u001fH\u0014JG\u0010\u00a2\u0001\u001a\u00020\u0015*\u00030\u009b\u00012\u0006\u0010<\u001a\u00020&2\b\u0010\u0098\u0001\u001a\u00030\u00a0\u00012%\u0010\u009f\u0001\u001a \u0012\u0015\u0012\u00130\u00a0\u0001\u00a2\u0006\r\b3\u0012\t\b4\u0012\u0005\b\b(\u00a1\u0001\u0012\u0005\u0012\u00030\u0084\u00010\u001fH\u0002J\t\u0010\u00a3\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a4\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a5\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a6\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a7\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a8\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00a9\u0001\u001a\u00020\u0015H\u0002J\t\u0010\u00aa\u0001\u001a\u00020\u0015H\u0002J\u0017\u0010\u00ab\u0001\u001a\u00020\u001b*\u00020\u001b2\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0002R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0084.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\n \f*\u0004\u0018\u00010(0(8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010)R&\u0010*\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.RC\u00102\u001a+\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u001f\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\"\"\u0004\b7\u0010$R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010;R\u0011\u0010B\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010;R\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020M\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0011\u0010P\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010?R\u0011\u0010R\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010;R\u0011\u0010T\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010;R\u0011\u0010V\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010;R\u0011\u0010X\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010GR\u0011\u0010Z\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010GR\u0011\u0010\\\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010GR\u0011\u0010^\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010GR\u0011\u0010`\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010;R\u0011\u0010b\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010;R\u0011\u0010d\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010?R\u0011\u0010f\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010;R\u0011\u0010h\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010;R\u0011\u0010j\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010;R\u0016\u0010l\u001a\u00020m8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010oR\u0011\u0010p\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010;R\u0011\u0010r\u001a\u00020s\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010uR\u0011\u0010v\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010;R\u0011\u0010x\u001a\u00020s\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010uR\u0011\u0010z\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010;R\u0011\u0010|\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010;R\u0011\u0010~\u001a\u00020s\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010u\u00a8\u0006\u00ae\u0001"}, d2={"Lcom/acutecoder/pdf/ui/PdfToolBar;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "layoutInflater", "Landroid/view/LayoutInflater;", "kotlin.jvm.PlatformType", "Landroid/view/LayoutInflater;", "value", "Lcom/acutecoder/pdf/PdfViewer;", "pdfViewer", "getPdfViewer", "()Lcom/acutecoder/pdf/PdfViewer;", "onBack", "Lkotlin/Function0;", "", "getOnBack", "()Lkotlin/jvm/functions/Function0;", "setOnBack", "(Lkotlin/jvm/functions/Function0;)V", "alertDialogBuilder", "Landroidx/appcompat/app/AlertDialog$Builder;", "getAlertDialogBuilder", "setAlertDialogBuilder", "showDialog", "Lkotlin/Function1;", "Landroid/app/Dialog;", "getShowDialog", "()Lkotlin/jvm/functions/Function1;", "setShowDialog", "(Lkotlin/jvm/functions/Function1;)V", "fileName", "", "root", "Landroid/view/View;", "Landroid/view/View;", "contentColor", "getContentColor", "()I", "setContentColor", "(I)V", "popupBackgroundColor", "getPopupBackgroundColor", "setPopupBackgroundColor", "pickColor", "Lkotlin/ParameterName;", "name", "onPickColor", "getPickColor", "setPickColor", "back", "Landroid/widget/ImageView;", "getBack", "()Landroid/widget/ImageView;", "title", "Landroid/widget/TextView;", "getTitle", "()Landroid/widget/TextView;", "find", "getFind", "more", "getMore", "findBar", "Landroid/widget/LinearLayout;", "getFindBar", "()Landroid/widget/LinearLayout;", "findEditText", "Landroid/widget/EditText;", "getFindEditText", "()Landroid/widget/EditText;", "findProgressBar", "Landroid/widget/ProgressBar;", "getFindProgressBar", "()Landroid/widget/ProgressBar;", "findInfo", "getFindInfo", "findPrevious", "getFindPrevious", "findNext", "getFindNext", "edit", "getEdit", "editorBar", "getEditorBar", "highlightBar", "getHighlightBar", "freeTextBar", "getFreeTextBar", "inkBar", "getInkBar", "undo", "getUndo", "redo", "getRedo", "editTitle", "getEditTitle", "highlight", "getHighlight", "freeText", "getFreeText", "ink", "getInk", "showAllHighlights", "Landroid/widget/Switch;", "getShowAllHighlights", "()Landroid/widget/Switch;", "highlightThickness", "getHighlightThickness", "highlightColor", "Lcom/acutecoder/pdf/ui/ColorItemView;", "getHighlightColor", "()Lcom/acutecoder/pdf/ui/ColorItemView;", "freeFontSize", "getFreeFontSize", "freeFontColor", "getFreeFontColor", "inkThickness", "getInkThickness", "inkOpacity", "getInkOpacity", "inkColor", "getInkColor", "onFinishInflate", "setupWith", "setFileName", "setAsTitle", "", "setTitle", "isFindBarVisible", "setFindBarVisible", "visible", "setEditorBarVisible", "isEditorBarVisible", "setHighlightBarVisible", "isHighlightBarVisible", "setFreeTextBarVisible", "isFreeTextBarVisible", "setInkBarVisible", "isInkBarVisible", "setEditorMainIconsVisible", "mainIconsVisible", "undoRedoVisible", "applyContentColor", "initListeners", "initSecondaryMenu", "handlePopupMenuItemClick", "item", "Landroid/view/MenuItem;", "getPopupMenu", "Landroid/widget/PopupMenu;", "anchorView", "addDefaultMenus", "popupMenu", "filter", "Lcom/acutecoder/pdf/ui/PdfToolBarMenuItem;", "menuItem", "addMenu", "showZoomDialog", "showGoToPageDialog", "showScrollModeDialog", "showSinglePageArrangementDialog", "showSpreadModeDialog", "showAlignModeDialog", "showSnapPageDialog", "showPropertiesDialog", "setPropertiesView", "properties", "Lcom/acutecoder/pdf/PdfDocumentProperties;", "ui_release"})
@SourceDebugExtension(value={"SMAP\nPdfToolBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfToolBar.kt\ncom/acutecoder/pdf/ui/PdfToolBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 PdfToolBar.kt\ncom/acutecoder/pdf/ui/PdfToolBarKt\n*L\n1#1,828:1\n1#2:829\n37#3,2:830\n37#3,2:832\n792#4:834\n792#4:835\n792#4:836\n792#4:837\n792#4:838\n792#4:839\n792#4:840\n792#4:841\n792#4:842\n792#4:843\n792#4:844\n792#4:845\n792#4:846\n*S KotlinDebug\n*F\n+ 1 PdfToolBar.kt\ncom/acutecoder/pdf/ui/PdfToolBar\n*L\n707#1:830,2\n716#1:832,2\n772#1:834\n773#1:835\n774#1:836\n775#1:837\n776#1:838\n777#1:839\n778#1:840\n779#1:841\n780#1:842\n781#1:843\n782#1:844\n783#1:845\n784#1:846\n*E\n"})
public class PdfToolBar
extends FrameLayout {
    private final LayoutInflater layoutInflater;
    private PdfViewer pdfViewer;
    @Nullable
    private Function0<Unit> onBack;
    @NotNull
    private Function0<? extends AlertDialog.Builder> alertDialogBuilder;
    @NotNull
    private Function1<? super Dialog, Unit> showDialog;
    @Nullable
    private String fileName;
    @SuppressLint(value={"InflateParams"})
    private final View root;
    @ColorInt
    private int contentColor;
    private int popupBackgroundColor;
    @Nullable
    private Function1<? super Function1<? super Integer, Unit>, Unit> pickColor;
    @NotNull
    private final ImageView back;
    @NotNull
    private final TextView title;
    @NotNull
    private final ImageView find;
    @NotNull
    private final ImageView more;
    @NotNull
    private final LinearLayout findBar;
    @NotNull
    private final EditText findEditText;
    @NotNull
    private final ProgressBar findProgressBar;
    @NotNull
    private final TextView findInfo;
    @NotNull
    private final ImageView findPrevious;
    @NotNull
    private final ImageView findNext;
    @NotNull
    private final ImageView edit;
    @NotNull
    private final LinearLayout editorBar;
    @NotNull
    private final LinearLayout highlightBar;
    @NotNull
    private final LinearLayout freeTextBar;
    @NotNull
    private final LinearLayout inkBar;
    @NotNull
    private final ImageView undo;
    @NotNull
    private final ImageView redo;
    @NotNull
    private final TextView editTitle;
    @NotNull
    private final ImageView highlight;
    @NotNull
    private final ImageView freeText;
    @NotNull
    private final ImageView ink;
    @SuppressLint(value={"UseSwitchCompatOrMaterialCode"})
    @NotNull
    private final Switch showAllHighlights;
    @NotNull
    private final ImageView highlightThickness;
    @NotNull
    private final ColorItemView highlightColor;
    @NotNull
    private final ImageView freeFontSize;
    @NotNull
    private final ColorItemView freeFontColor;
    @NotNull
    private final ImageView inkThickness;
    @NotNull
    private final ImageView inkOpacity;
    @NotNull
    private final ColorItemView inkColor;

    @JvmOverloads
    public PdfToolBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            this.layoutInflater = LayoutInflater.from((Context)context);
            this.alertDialogBuilder = () -> PdfToolBar.alertDialogBuilder$lambda$0(context);
            this.showDialog = PdfToolBar::showDialog$lambda$1;
            this.root = this.layoutInflater.inflate(R.layout.pdf_toolbar, null);
            this.contentColor = -16777216;
            this.popupBackgroundColor = -1;
            View view = this.root.findViewById(R.id.back);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
            this.back = (ImageView)view;
            View view2 = this.root.findViewById(R.id.title);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
            this.title = (TextView)view2;
            View view3 = this.root.findViewById(R.id.find);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
            this.find = (ImageView)view3;
            View view4 = this.root.findViewById(R.id.more);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
            this.more = (ImageView)view4;
            View view5 = this.root.findViewById(R.id.find_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
            this.findBar = (LinearLayout)view5;
            View view6 = this.root.findViewById(R.id.find_edit_text);
            Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
            this.findEditText = (EditText)view6;
            View view7 = this.root.findViewById(R.id.find_progress_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
            this.findProgressBar = (ProgressBar)view7;
            View view8 = this.root.findViewById(R.id.find_info);
            Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(...)");
            this.findInfo = (TextView)view8;
            View view9 = this.root.findViewById(R.id.find_previous);
            Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"findViewById(...)");
            this.findPrevious = (ImageView)view9;
            View view10 = this.root.findViewById(R.id.find_next);
            Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"findViewById(...)");
            this.findNext = (ImageView)view10;
            View view11 = this.root.findViewById(R.id.edit);
            Intrinsics.checkNotNullExpressionValue((Object)view11, (String)"findViewById(...)");
            this.edit = (ImageView)view11;
            View view12 = this.root.findViewById(R.id.editor_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view12, (String)"findViewById(...)");
            this.editorBar = (LinearLayout)view12;
            View view13 = this.root.findViewById(R.id.highlight_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view13, (String)"findViewById(...)");
            this.highlightBar = (LinearLayout)view13;
            View view14 = this.root.findViewById(R.id.free_text_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view14, (String)"findViewById(...)");
            this.freeTextBar = (LinearLayout)view14;
            View view15 = this.root.findViewById(R.id.ink_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view15, (String)"findViewById(...)");
            this.inkBar = (LinearLayout)view15;
            View view16 = this.root.findViewById(R.id.undo);
            Intrinsics.checkNotNullExpressionValue((Object)view16, (String)"findViewById(...)");
            this.undo = (ImageView)view16;
            View view17 = this.root.findViewById(R.id.redo);
            Intrinsics.checkNotNullExpressionValue((Object)view17, (String)"findViewById(...)");
            this.redo = (ImageView)view17;
            View view18 = this.root.findViewById(R.id.edit_title);
            Intrinsics.checkNotNullExpressionValue((Object)view18, (String)"findViewById(...)");
            this.editTitle = (TextView)view18;
            View view19 = this.root.findViewById(R.id.highlight);
            Intrinsics.checkNotNullExpressionValue((Object)view19, (String)"findViewById(...)");
            this.highlight = (ImageView)view19;
            View view20 = this.root.findViewById(R.id.free_text);
            Intrinsics.checkNotNullExpressionValue((Object)view20, (String)"findViewById(...)");
            this.freeText = (ImageView)view20;
            View view21 = this.root.findViewById(R.id.ink);
            Intrinsics.checkNotNullExpressionValue((Object)view21, (String)"findViewById(...)");
            this.ink = (ImageView)view21;
            View view22 = this.root.findViewById(R.id.show_all_highlights);
            Intrinsics.checkNotNullExpressionValue((Object)view22, (String)"findViewById(...)");
            this.showAllHighlights = (Switch)view22;
            View view23 = this.root.findViewById(R.id.highlight_thickness);
            Intrinsics.checkNotNullExpressionValue((Object)view23, (String)"findViewById(...)");
            this.highlightThickness = (ImageView)view23;
            View view24 = this.root.findViewById(R.id.highlight_color);
            Intrinsics.checkNotNullExpressionValue((Object)view24, (String)"findViewById(...)");
            this.highlightColor = (ColorItemView)view24;
            View view25 = this.root.findViewById(R.id.free_font_size);
            Intrinsics.checkNotNullExpressionValue((Object)view25, (String)"findViewById(...)");
            this.freeFontSize = (ImageView)view25;
            View view26 = this.root.findViewById(R.id.free_font_color);
            Intrinsics.checkNotNullExpressionValue((Object)view26, (String)"findViewById(...)");
            this.freeFontColor = (ColorItemView)view26;
            View view27 = this.root.findViewById(R.id.ink_thickness);
            Intrinsics.checkNotNullExpressionValue((Object)view27, (String)"findViewById(...)");
            this.inkThickness = (ImageView)view27;
            View view28 = this.root.findViewById(R.id.ink_opacity);
            Intrinsics.checkNotNullExpressionValue((Object)view28, (String)"findViewById(...)");
            this.inkOpacity = (ImageView)view28;
            View view29 = this.root.findViewById(R.id.ink_color);
            Intrinsics.checkNotNullExpressionValue((Object)view29, (String)"findViewById(...)");
            this.inkColor = (ColorItemView)view29;
            this.initListeners();
            AttributeSet attributeSet = attrs;
            if (attributeSet == null) break block0;
            AttributeSet it = attributeSet;
            boolean bl = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.PdfToolBar, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray typedArray2 = typedArray;
            int contentColor = typedArray2.getColor(R.styleable.PdfToolBar_contentColor, -16777216);
            boolean showEditor = typedArray2.getBoolean(R.styleable.PdfToolBar_showEditor, false);
            this.setContentColor(contentColor);
            ImageView $this$lambda_u243_u24lambda_u242 = this.edit;
            boolean bl2 = false;
            $this$lambda_u243_u24lambda_u242.setVisibility(showEditor ? 0 : 8);
            this.popupBackgroundColor = typedArray2.getColor(R.styleable.PdfToolBar_popupBackgroundColor, -1);
            typedArray2.recycle();
        }
    }

    public /* synthetic */ PdfToolBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    protected final PdfViewer getPdfViewer() {
        PdfViewer pdfViewer = this.pdfViewer;
        if (pdfViewer != null) {
            return pdfViewer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pdfViewer");
        return null;
    }

    @Nullable
    public final Function0<Unit> getOnBack() {
        return this.onBack;
    }

    public final void setOnBack(@Nullable Function0<Unit> function0) {
        this.onBack = function0;
    }

    @NotNull
    public final Function0<AlertDialog.Builder> getAlertDialogBuilder() {
        return this.alertDialogBuilder;
    }

    public final void setAlertDialogBuilder(@NotNull Function0<? extends AlertDialog.Builder> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.alertDialogBuilder = function0;
    }

    @NotNull
    public final Function1<Dialog, Unit> getShowDialog() {
        return this.showDialog;
    }

    public final void setShowDialog(@NotNull Function1<? super Dialog, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.showDialog = function1;
    }

    public final int getContentColor() {
        return this.contentColor;
    }

    public final void setContentColor(int value) {
        this.contentColor = value;
        this.applyContentColor(value);
    }

    public final int getPopupBackgroundColor() {
        return this.popupBackgroundColor;
    }

    public final void setPopupBackgroundColor(int n) {
        this.popupBackgroundColor = n;
    }

    @Nullable
    public final Function1<Function1<? super Integer, Unit>, Unit> getPickColor() {
        return this.pickColor;
    }

    public final void setPickColor(@Nullable Function1<? super Function1<? super Integer, Unit>, Unit> function1) {
        this.pickColor = function1;
    }

    @NotNull
    public final ImageView getBack() {
        return this.back;
    }

    @NotNull
    public final TextView getTitle() {
        return this.title;
    }

    @NotNull
    public final ImageView getFind() {
        return this.find;
    }

    @NotNull
    public final ImageView getMore() {
        return this.more;
    }

    @NotNull
    public final LinearLayout getFindBar() {
        return this.findBar;
    }

    @NotNull
    public final EditText getFindEditText() {
        return this.findEditText;
    }

    @NotNull
    public final ProgressBar getFindProgressBar() {
        return this.findProgressBar;
    }

    @NotNull
    public final TextView getFindInfo() {
        return this.findInfo;
    }

    @NotNull
    public final ImageView getFindPrevious() {
        return this.findPrevious;
    }

    @NotNull
    public final ImageView getFindNext() {
        return this.findNext;
    }

    @NotNull
    public final ImageView getEdit() {
        return this.edit;
    }

    @NotNull
    public final LinearLayout getEditorBar() {
        return this.editorBar;
    }

    @NotNull
    public final LinearLayout getHighlightBar() {
        return this.highlightBar;
    }

    @NotNull
    public final LinearLayout getFreeTextBar() {
        return this.freeTextBar;
    }

    @NotNull
    public final LinearLayout getInkBar() {
        return this.inkBar;
    }

    @NotNull
    public final ImageView getUndo() {
        return this.undo;
    }

    @NotNull
    public final ImageView getRedo() {
        return this.redo;
    }

    @NotNull
    public final TextView getEditTitle() {
        return this.editTitle;
    }

    @NotNull
    public final ImageView getHighlight() {
        return this.highlight;
    }

    @NotNull
    public final ImageView getFreeText() {
        return this.freeText;
    }

    @NotNull
    public final ImageView getInk() {
        return this.ink;
    }

    @NotNull
    public final Switch getShowAllHighlights() {
        return this.showAllHighlights;
    }

    @NotNull
    public final ImageView getHighlightThickness() {
        return this.highlightThickness;
    }

    @NotNull
    public final ColorItemView getHighlightColor() {
        return this.highlightColor;
    }

    @NotNull
    public final ImageView getFreeFontSize() {
        return this.freeFontSize;
    }

    @NotNull
    public final ColorItemView getFreeFontColor() {
        return this.freeFontColor;
    }

    @NotNull
    public final ImageView getInkThickness() {
        return this.inkThickness;
    }

    @NotNull
    public final ImageView getInkOpacity() {
        return this.inkOpacity;
    }

    @NotNull
    public final ColorItemView getInkColor() {
        return this.inkColor;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addView(this.root);
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setupWith(@NotNull PdfViewer pdfViewer) {
        Intrinsics.checkNotNullParameter((Object)pdfViewer, (String)"pdfViewer");
        if (this.pdfViewer != null && Intrinsics.areEqual((Object)this.getPdfViewer(), (Object)pdfViewer)) {
            return;
        }
        this.pdfViewer = pdfViewer;
        this.initSecondaryMenu();
        pdfViewer.addListener(new PdfListener(this){
            private int total;
            final /* synthetic */ PdfToolBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageLoadStart() {
                this.this$0.getFind().setEnabled(false);
                this.this$0.getMore().setEnabled(false);
                this.this$0.getEdit().setEnabled(false);
                this.this$0.setFindBarVisible(false);
            }

            public void onPageLoadSuccess(int pagesCount) {
                this.this$0.getFind().setEnabled(true);
                this.this$0.getMore().setEnabled(true);
                this.this$0.getEdit().setEnabled(true);
            }

            public void onLoadProperties(PdfDocumentProperties properties) {
                Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
                CharSequence charSequence = this.this$0.getTitle().getText();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    this.this$0.setTitle(properties.getTitle());
                }
            }

            public void onFindMatchChange(int current, int total) {
                this.total = total;
                this.this$0.getFindInfo().setText((CharSequence)(current + " of " + total));
            }

            public void onFindMatchStart() {
                this.this$0.getFindProgressBar().setVisibility(0);
            }

            public void onFindMatchComplete(boolean found) {
                if (!found) {
                    Toast.makeText((Context)this.this$0.getContext(), (CharSequence)"No match found!", (int)0).show();
                }
                this.this$0.getFindProgressBar().setVisibility(8);
            }

            public void onPageLoadFailed(String errorMessage) {
                PdfListener.DefaultImpls.onPageLoadFailed((PdfListener)this, (String)errorMessage);
            }

            public void onPageChange(int pageNumber) {
                PdfListener.DefaultImpls.onPageChange((PdfListener)this, (int)pageNumber);
            }

            public void onScaleChange(float scale) {
                PdfListener.DefaultImpls.onScaleChange((PdfListener)this, (float)scale);
            }

            public void onSavePdf(byte[] pdfAsBytes) {
                PdfListener.DefaultImpls.onSavePdf((PdfListener)this, (byte[])pdfAsBytes);
            }

            public void onScrollChange(int currentOffset, int totalOffset, boolean isHorizontalScroll) {
                PdfListener.DefaultImpls.onScrollChange((PdfListener)this, (int)currentOffset, (int)totalOffset, (boolean)isHorizontalScroll);
            }

            public void onPasswordDialogChange(boolean isOpen) {
                PdfListener.DefaultImpls.onPasswordDialogChange((PdfListener)this, (boolean)isOpen);
            }

            public void onScrollModeChange(PdfViewer.PageScrollMode scrollMode) {
                PdfListener.DefaultImpls.onScrollModeChange((PdfListener)this, (PdfViewer.PageScrollMode)scrollMode);
            }

            public void onSpreadModeChange(PdfViewer.PageSpreadMode spreadMode) {
                PdfListener.DefaultImpls.onSpreadModeChange((PdfListener)this, (PdfViewer.PageSpreadMode)spreadMode);
            }

            public void onRotationChange(PdfViewer.PageRotation rotation) {
                PdfListener.DefaultImpls.onRotationChange((PdfListener)this, (PdfViewer.PageRotation)rotation);
            }

            public void onSingleClick() {
                PdfListener.DefaultImpls.onSingleClick((PdfListener)this);
            }

            public void onDoubleClick() {
                PdfListener.DefaultImpls.onDoubleClick((PdfListener)this);
            }

            public void onLongClick() {
                PdfListener.DefaultImpls.onLongClick((PdfListener)this);
            }

            public void onLinkClick(String link) {
                PdfListener.DefaultImpls.onLinkClick((PdfListener)this, (String)link);
            }

            public void onSnapChange(boolean snapPage) {
                PdfListener.DefaultImpls.onSnapChange((PdfListener)this, (boolean)snapPage);
            }

            public void onSinglePageArrangementChange(boolean requestedArrangement, boolean appliedArrangement) {
                PdfListener.DefaultImpls.onSinglePageArrangementChange((PdfListener)this, (boolean)requestedArrangement, (boolean)appliedArrangement);
            }

            public void onEditorHighlightColorChange(@ColorInt int highlightColor) {
                PdfListener.DefaultImpls.onEditorHighlightColorChange((PdfListener)this, (int)highlightColor);
            }

            public void onEditorShowAllHighlightsChange(boolean showAll) {
                PdfListener.DefaultImpls.onEditorShowAllHighlightsChange((PdfListener)this, (boolean)showAll);
            }

            public void onEditorHighlightThicknessChange(@IntRange(from=8L, to=24L) int thickness) {
                PdfListener.DefaultImpls.onEditorHighlightThicknessChange((PdfListener)this, (int)thickness);
            }

            public void onEditorFreeFontColorChange(@ColorInt int fontColor) {
                PdfListener.DefaultImpls.onEditorFreeFontColorChange((PdfListener)this, (int)fontColor);
            }

            public void onEditorFreeFontSizeChange(@IntRange(from=5L, to=100L) int fontSize) {
                PdfListener.DefaultImpls.onEditorFreeFontSizeChange((PdfListener)this, (int)fontSize);
            }

            public void onEditorInkColorChange(@ColorInt int color) {
                PdfListener.DefaultImpls.onEditorInkColorChange((PdfListener)this, (int)color);
            }

            public void onEditorInkThicknessChange(@IntRange(from=1L, to=20L) int thickness) {
                PdfListener.DefaultImpls.onEditorInkThicknessChange((PdfListener)this, (int)thickness);
            }

            public void onEditorInkOpacityChange(@IntRange(from=1L, to=100L) int opacity) {
                PdfListener.DefaultImpls.onEditorInkOpacityChange((PdfListener)this, (int)opacity);
            }

            public void onScaleLimitChange(@FloatRange(from=-4.0, to=10.0) float minPageScale, @FloatRange(from=-4.0, to=10.0) float maxPageScale, @FloatRange(from=-4.0, to=10.0) float defaultPageScale) {
                PdfListener.DefaultImpls.onScaleLimitChange((PdfListener)this, (float)minPageScale, (float)maxPageScale, (float)defaultPageScale);
            }

            public void onActualScaleLimitChange(@FloatRange(from=0.0, to=10.0) float minPageScale, @FloatRange(from=0.0, to=10.0) float maxPageScale, @FloatRange(from=0.0, to=10.0) float defaultPageScale) {
                PdfListener.DefaultImpls.onActualScaleLimitChange((PdfListener)this, (float)minPageScale, (float)maxPageScale, (float)defaultPageScale);
            }

            public void onAlignModeChange(PdfViewer.PageAlignMode requestedMode, PdfViewer.PageAlignMode appliedMode) {
                PdfListener.DefaultImpls.onAlignModeChange((PdfListener)this, (PdfViewer.PageAlignMode)requestedMode, (PdfViewer.PageAlignMode)appliedMode);
            }

            public void onScrollSpeedLimitChange(PdfViewer.ScrollSpeedLimit requestedLimit, PdfViewer.ScrollSpeedLimit appliedLimit) {
                PdfListener.DefaultImpls.onScrollSpeedLimitChange((PdfListener)this, (PdfViewer.ScrollSpeedLimit)requestedLimit, (PdfViewer.ScrollSpeedLimit)appliedLimit);
            }
        });
        this.find.setEnabled(false);
        this.more.setEnabled(false);
        this.edit.setEnabled(false);
        this.showAllHighlights.setChecked(pdfViewer.getEditor().getShowAllHighlights());
        this.showAllHighlights.setOnCheckedChangeListener((arg_0, arg_1) -> PdfToolBar.setupWith$lambda$4(pdfViewer, arg_0, arg_1));
    }

    public final void setFileName(@NotNull String name, boolean setAsTitle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.fileName = name;
        if (setAsTitle) {
            this.setTitle(name);
        }
    }

    public static /* synthetic */ void setFileName$default(PdfToolBar pdfToolBar, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setFileName");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        pdfToolBar.setFileName(string, bl);
    }

    public final void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.title.setText((CharSequence)title);
    }

    public final boolean isFindBarVisible() {
        return this.findBar.getVisibility() == 0;
    }

    public final void setFindBarVisible(boolean visible) {
        this.findBar.setVisibility(visible ? 0 : 8);
        this.findEditText.setText((CharSequence)"");
        this.findInfo.setText((CharSequence)"");
        if (visible) {
            ExtensionsKt.requestKeyboard(this.findEditText);
        } else {
            this.getPdfViewer().getFindController().stopFind();
            ExtensionsKt.hideKeyboard((View)this.findEditText);
        }
    }

    public final void setEditorBarVisible(boolean visible) {
        this.editorBar.setVisibility(visible ? 0 : 8);
        this.setEditorMainIconsVisible(true, false);
        this.highlightBar.setVisibility(8);
        this.freeTextBar.setVisibility(8);
        this.inkBar.setVisibility(8);
        this.getPdfViewer().getEditor().setTextHighlighterOn(false);
        this.getPdfViewer().getEditor().setFreeTextOn(false);
        this.getPdfViewer().getEditor().setInkOn(false);
    }

    public final boolean isEditorBarVisible() {
        return this.editorBar.getVisibility() == 0;
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setHighlightBarVisible(boolean visible) {
        this.editTitle.setText((CharSequence)"Highlight");
        this.highlightBar.setVisibility(visible ? 0 : 8);
        this.getPdfViewer().getEditor().setTextHighlighterOn(visible);
        this.freeTextBar.setVisibility(8);
        this.inkBar.setVisibility(8);
        this.showAllHighlights.setChecked(this.getPdfViewer().getEditor().getShowAllHighlights());
        this.highlightColor.setColor(this.getPdfViewer().getEditor().getHighlightColor());
        this.setEditorMainIconsVisible(false, true);
    }

    public final boolean isHighlightBarVisible() {
        return this.highlightBar.getVisibility() == 0;
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setFreeTextBarVisible(boolean visible) {
        this.editTitle.setText((CharSequence)"Text");
        this.highlightBar.setVisibility(8);
        this.freeTextBar.setVisibility(visible ? 0 : 8);
        this.getPdfViewer().getEditor().setFreeTextOn(visible);
        this.inkBar.setVisibility(8);
        this.freeFontColor.setColor(this.getPdfViewer().getEditor().getFreeFontColor());
        this.setEditorMainIconsVisible(false, true);
    }

    public final boolean isFreeTextBarVisible() {
        return this.freeTextBar.getVisibility() == 0;
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void setInkBarVisible(boolean visible) {
        this.editTitle.setText((CharSequence)"Draw");
        this.highlightBar.setVisibility(8);
        this.freeTextBar.setVisibility(8);
        this.inkBar.setVisibility(visible ? 0 : 8);
        this.getPdfViewer().getEditor().setInkOn(visible);
        this.highlightColor.setColor(this.getPdfViewer().getEditor().getHighlightColor());
        this.inkColor.setColor(this.getPdfViewer().getEditor().getInkColor());
        this.setEditorMainIconsVisible(false, true);
    }

    public final boolean isInkBarVisible() {
        return this.inkBar.getVisibility() == 0;
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void setEditorMainIconsVisible(boolean mainIconsVisible, boolean undoRedoVisible) {
        if (mainIconsVisible) {
            this.editTitle.setText((CharSequence)"Edit");
            this.highlight.setVisibility(0);
            this.freeText.setVisibility(0);
            this.ink.setVisibility(0);
        } else {
            this.highlight.setVisibility(8);
            this.freeText.setVisibility(8);
            this.ink.setVisibility(8);
        }
        if (undoRedoVisible) {
            this.undo.setVisibility(0);
            this.redo.setVisibility(0);
        } else {
            this.undo.setVisibility(8);
            this.redo.setVisibility(8);
        }
    }

    private final void applyContentColor(@ColorInt int contentColor) {
        ExtensionsKt.setTintModes(this.find, contentColor);
        ExtensionsKt.setTintModes(this.more, contentColor);
        ExtensionsKt.setTintModes(this.back, contentColor);
        this.title.setTextColor(contentColor);
        this.findEditText.setTextColor(contentColor);
        ExtensionsKt.setTintModes(this.findNext, contentColor);
        ExtensionsKt.setTintModes(this.findPrevious, contentColor);
        ExtensionsKt.setTintModes(this.edit, contentColor);
        ExtensionsKt.setTintModes(this.undo, contentColor);
        ExtensionsKt.setTintModes(this.redo, contentColor);
        this.editTitle.setTextColor(contentColor);
        ExtensionsKt.setTintModes(this.highlight, contentColor);
        ExtensionsKt.setTintModes(this.freeText, contentColor);
        ExtensionsKt.setTintModes(this.ink, contentColor);
        ExtensionsKt.setTintModes(this.highlightThickness, contentColor);
        ExtensionsKt.setTintModes(this.freeFontSize, contentColor);
        ExtensionsKt.setTintModes(this.inkThickness, contentColor);
        ExtensionsKt.setTintModes(this.inkOpacity, contentColor);
        this.highlightColor.setBorderColor(contentColor);
        this.freeFontColor.setBorderColor(contentColor);
        this.inkColor.setBorderColor(contentColor);
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void initListeners() {
        this.back.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$5(this, arg_0));
        this.find.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$6(this, arg_0));
        this.findNext.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$7(this, arg_0));
        this.findPrevious.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$8(this, arg_0));
        this.edit.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$9(this, arg_0));
        this.highlight.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$10(this, arg_0));
        this.freeText.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$11(this, arg_0));
        this.ink.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$12(this, arg_0));
        this.findEditText.setOnEditorActionListener((arg_0, arg_1, arg_2) -> PdfToolBar.initListeners$lambda$13(this, arg_0, arg_1, arg_2));
        this.undo.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$14(this, arg_0));
        this.redo.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$15(this, arg_0));
        this.highlightThickness.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$20(this, arg_0));
        this.highlightColor.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$24(this, arg_0));
        this.freeFontSize.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$29(this, arg_0));
        this.freeFontColor.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$31(this, arg_0));
        this.inkThickness.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$36(this, arg_0));
        this.inkOpacity.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$41(this, arg_0));
        this.inkColor.setOnClickListener(arg_0 -> PdfToolBar.initListeners$lambda$43(this, arg_0));
    }

    private final void initSecondaryMenu() {
        this.more.setOnClickListener(arg_0 -> PdfToolBar.initSecondaryMenu$lambda$44(this, arg_0));
    }

    protected boolean handlePopupMenuItemClick(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == PdfToolBarMenuItem.DOWNLOAD.getId$ui_release()) {
            this.getPdfViewer().downloadFile();
        } else if (n == PdfToolBarMenuItem.ZOOM.getId$ui_release()) {
            this.showZoomDialog();
        } else if (n == PdfToolBarMenuItem.GO_TO_PAGE.getId$ui_release()) {
            this.showGoToPageDialog();
        } else if (n == PdfToolBarMenuItem.ROTATE_CLOCK_WISE.getId$ui_release()) {
            this.getPdfViewer().rotateClockWise();
        } else if (n == PdfToolBarMenuItem.ROTATE_ANTI_CLOCK_WISE.getId$ui_release()) {
            this.getPdfViewer().rotateCounterClockWise();
        } else if (n == PdfToolBarMenuItem.SCROLL_MODE.getId$ui_release()) {
            this.showScrollModeDialog();
        } else if (n == PdfToolBarMenuItem.SINGLE_PAGE_ARRANGEMENT.getId$ui_release()) {
            this.showSinglePageArrangementDialog();
        } else if (n == PdfToolBarMenuItem.SPREAD_MODE.getId$ui_release()) {
            this.showSpreadModeDialog();
        } else if (n == PdfToolBarMenuItem.ALIGN_MODE.getId$ui_release()) {
            this.showAlignModeDialog();
        } else if (n == PdfToolBarMenuItem.SNAP_PAGE.getId$ui_release()) {
            this.showSnapPageDialog();
        } else if (n == PdfToolBarMenuItem.PROPERTIES.getId$ui_release()) {
            this.showPropertiesDialog();
        }
        return item.getItemId() < PdfToolBarMenuItem.getEntries().size();
    }

    @NotNull
    protected PopupMenu getPopupMenu(@NotNull View anchorView) {
        Intrinsics.checkNotNullParameter((Object)anchorView, (String)"anchorView");
        return PdfToolBar.addDefaultMenus$default(this, new PopupMenu(this.getContext(), anchorView), null, 2, null);
    }

    @NotNull
    protected PopupMenu addDefaultMenus(@NotNull PopupMenu popupMenu, @NotNull Function1<? super PdfToolBarMenuItem, Boolean> filter) {
        PopupMenu popupMenu2;
        Intrinsics.checkNotNullParameter((Object)popupMenu, (String)"popupMenu");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        PopupMenu $this$addDefaultMenus_u24lambda_u2447 = popupMenu2 = popupMenu;
        boolean bl = false;
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Download", PdfToolBarMenuItem.DOWNLOAD, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, ExtensionsKt.formatZoom(this.getPdfViewer().getCurrentPageScaleValue(), this.getPdfViewer().getCurrentPageScale()), PdfToolBarMenuItem.ZOOM, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Go to page", PdfToolBarMenuItem.GO_TO_PAGE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Rotate Clockwise", PdfToolBarMenuItem.ROTATE_CLOCK_WISE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Rotate Anti Clockwise", PdfToolBarMenuItem.ROTATE_ANTI_CLOCK_WISE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Scroll Mode", PdfToolBarMenuItem.SCROLL_MODE, filter);
        PdfViewer.PageScrollMode it = this.getPdfViewer().getPageScrollMode();
        boolean bl2 = false;
        boolean bl3 = it == PdfViewer.PageScrollMode.VERTICAL || it == PdfViewer.PageScrollMode.HORIZONTAL;
        if (bl3 && this.getPdfViewer().getPageSpreadMode() == PdfViewer.PageSpreadMode.NONE) {
            this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Single Page Arrangement", PdfToolBarMenuItem.SINGLE_PAGE_ARRANGEMENT, filter);
        }
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Split Mode", PdfToolBarMenuItem.SPREAD_MODE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Align Mode", PdfToolBarMenuItem.ALIGN_MODE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Snap Page", PdfToolBarMenuItem.SNAP_PAGE, filter);
        this.addMenu($this$addDefaultMenus_u24lambda_u2447, "Properties", PdfToolBarMenuItem.PROPERTIES, filter);
        return popupMenu2;
    }

    public static /* synthetic */ PopupMenu addDefaultMenus$default(PdfToolBar pdfToolBar, PopupMenu popupMenu, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDefaultMenus");
        }
        if ((n & 2) != 0) {
            function1 = PdfToolBar::addDefaultMenus$lambda$45;
        }
        return pdfToolBar.addDefaultMenus(popupMenu, (Function1<? super PdfToolBarMenuItem, Boolean>)function1);
    }

    private final void addMenu(PopupMenu $this$addMenu, String title, PdfToolBarMenuItem item, Function1<? super PdfToolBarMenuItem, Boolean> filter) {
        if (((Boolean)filter.invoke((Object)item)).booleanValue()) {
            $this$addMenu.getMenu().add(0, item.getId$ui_release(), 0, (CharSequence)title);
        }
    }

    private final void showZoomDialog() {
        String[] stringArray = new String[]{"Automatic", "Page Fit", "Page Width", "Actual Size", "50%", "75%", "100%", "125%", "150%", "200%", "300%", "400%"};
        String[] displayOptions = stringArray;
        String[] stringArray2 = new String[]{Zoom.AUTOMATIC.getValue$ui_release(), Zoom.PAGE_FIT.getValue$ui_release(), Zoom.PAGE_WIDTH.getValue$ui_release(), Zoom.ACTUAL_SIZE.getValue$ui_release(), "0.5", "0.75", "1", "1.25", "1.5", "2", "3", "4"};
        String[] options = stringArray2;
        AlertDialog alertDialog = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Select Zoom Level").setSingleChoiceItems((CharSequence[])displayOptions, ExtensionsKt.findSelectedOption(options, this.getPdfViewer().getCurrentPageScaleValue()), (arg_0, arg_1) -> PdfToolBar.showZoomDialog$lambda$48(this, options, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showZoomDialog$lambda$49).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        this.showDialog.invoke((Object)dialog);
    }

    private final void showGoToPageDialog() {
        View root = this.layoutInflater.inflate(R.layout.pdf_go_to_page_dialog, null);
        View view = root.findViewById(R.id.go_to_page_field);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        EditText field = (EditText)view;
        Function2 gotTo = (arg_0, arg_1) -> PdfToolBar.showGoToPageDialog$lambda$50(this, arg_0, arg_1);
        AlertDialog alertDialog = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Go to page").setView(root).setPositiveButton((CharSequence)"Go", (arg_0, arg_1) -> PdfToolBar.showGoToPageDialog$lambda$51(gotTo, field, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showGoToPageDialog$lambda$52).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        field.setOnEditorActionListener((arg_0, arg_1, arg_2) -> PdfToolBar.showGoToPageDialog$lambda$53(gotTo, field, dialog, arg_0, arg_1, arg_2));
        dialog.setOnShowListener(arg_0 -> PdfToolBar.showGoToPageDialog$lambda$55(field, arg_0));
        this.showDialog.invoke((Object)dialog);
    }

    private final void showScrollModeDialog() {
        String[] stringArray = new String[]{"Vertical", "Horizontal", "Wrapped", "Single Page"};
        String[] displayOptions = stringArray;
        String[] stringArray2 = new String[]{"VERTICAL", "HORIZONTAL", "WRAPPED", "SINGLE_PAGE"};
        String[] options = stringArray2;
        AlertDialog alertDialog = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Select Page Scroll Mode").setSingleChoiceItems((CharSequence[])displayOptions, ExtensionsKt.findSelectedOption(options, this.getPdfViewer().getPageScrollMode().name()), (arg_0, arg_1) -> PdfToolBar.showScrollModeDialog$lambda$56(this, options, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showScrollModeDialog$lambda$57).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        this.showDialog.invoke((Object)dialog);
    }

    private final void showSinglePageArrangementDialog() {
        View root = this.layoutInflater.inflate(R.layout.pdf_snap_page_dialog, null);
        SwitchCompat switchCompat = (SwitchCompat)root.findViewById(R.id.snap_page);
        switchCompat.setChecked(this.getPdfViewer().getSinglePageArrangement());
        ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Single Page Arrangement").setView(root).setPositiveButton((CharSequence)"Done", (arg_0, arg_1) -> PdfToolBar.showSinglePageArrangementDialog$lambda$58(this, switchCompat, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showSinglePageArrangementDialog$lambda$59).create().show();
    }

    private final void showSpreadModeDialog() {
        String[] stringArray = new String[]{"None", "Odd", "Even"};
        String[] displayOptions = stringArray;
        String[] stringArray2 = new String[]{"NONE", "ODD", "EVEN"};
        String[] options = stringArray2;
        AlertDialog alertDialog = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Select Page Split Mode").setSingleChoiceItems((CharSequence[])displayOptions, ExtensionsKt.findSelectedOption(options, this.getPdfViewer().getPageSpreadMode().name()), (arg_0, arg_1) -> PdfToolBar.showSpreadModeDialog$lambda$60(this, options, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showSpreadModeDialog$lambda$61).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        this.showDialog.invoke((Object)dialog);
    }

    private final void showAlignModeDialog() {
        List list;
        List $this$showAlignModeDialog_u24lambda_u2462 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$showAlignModeDialog_u24lambda_u2462.add("Default");
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.VERTICAL && this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.WRAPPED) {
            $this$showAlignModeDialog_u24lambda_u2462.add("Center Vertically");
        }
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.HORIZONTAL) {
            $this$showAlignModeDialog_u24lambda_u2462.add("Center Horizontally");
        }
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() == PdfViewer.PageScrollMode.SINGLE_PAGE) {
            $this$showAlignModeDialog_u24lambda_u2462.add("Center Both");
        }
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] displayOptions = thisCollection$iv.toArray(new String[0]);
        List $this$showAlignModeDialog_u24lambda_u2463 = $i$f$toTypedArray = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        $this$showAlignModeDialog_u24lambda_u2463.add("DEFAULT");
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.VERTICAL && this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.WRAPPED) {
            $this$showAlignModeDialog_u24lambda_u2463.add("CENTER_VERTICAL");
        }
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() != PdfViewer.PageScrollMode.HORIZONTAL) {
            $this$showAlignModeDialog_u24lambda_u2463.add("CENTER_HORIZONTAL");
        }
        if (this.getPdfViewer().getSinglePageArrangement() || this.getPdfViewer().getPageScrollMode() == PdfViewer.PageScrollMode.SINGLE_PAGE) {
            $this$showAlignModeDialog_u24lambda_u2463.add("CENTER_BOTH");
        }
        Collection $this$toTypedArray$iv2 = CollectionsKt.build((List)$i$f$toTypedArray);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] options = thisCollection$iv2.toArray(new String[0]);
        AlertDialog alertDialog = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Select Page Align Mode").setSingleChoiceItems((CharSequence[])displayOptions, ExtensionsKt.findSelectedOption(options, this.getPdfViewer().getPageAlignMode().name()), (arg_0, arg_1) -> PdfToolBar.showAlignModeDialog$lambda$64(this, options, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showAlignModeDialog$lambda$65).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog, (String)"create(...)");
        AlertDialog dialog = alertDialog;
        this.showDialog.invoke((Object)dialog);
    }

    private final void showSnapPageDialog() {
        View root = this.layoutInflater.inflate(R.layout.pdf_snap_page_dialog, null);
        SwitchCompat switchCompat = (SwitchCompat)root.findViewById(R.id.snap_page);
        switchCompat.setChecked(this.getPdfViewer().getSnapPage());
        ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Snap Page").setView(root).setPositiveButton((CharSequence)"Done", (arg_0, arg_1) -> PdfToolBar.showSnapPageDialog$lambda$66(this, switchCompat, arg_0, arg_1)).setNegativeButton((CharSequence)"Cancel", PdfToolBar::showSnapPageDialog$lambda$67).create().show();
    }

    private final void showPropertiesDialog() {
        PdfDocumentProperties pdfDocumentProperties;
        block3: {
            AlertDialog.Builder it;
            block2: {
                it = ((AlertDialog.Builder)this.alertDialogBuilder.invoke()).setTitle((CharSequence)"Document Properties");
                boolean bl = false;
                pdfDocumentProperties = this.getPdfViewer().getProperties();
                if (pdfDocumentProperties == null) break block2;
                PdfDocumentProperties properties = pdfDocumentProperties;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                AlertDialog.Builder builder = this.setPropertiesView(it, properties);
                pdfDocumentProperties = builder;
                if (builder != null) break block3;
            }
            pdfDocumentProperties = it.setMessage((CharSequence)"Properties not loaded yet!");
        }
        pdfDocumentProperties.setPositiveButton((CharSequence)"Close", PdfToolBar::showPropertiesDialog$lambda$70).create().show();
    }

    private final AlertDialog.Builder setPropertiesView(AlertDialog.Builder $this$setPropertiesView, PdfDocumentProperties properties) {
        CharSequence charSequence;
        View $this$find$iv;
        View root = this.layoutInflater.inflate(R.layout.pdf_properties_dialog, null);
        Intrinsics.checkNotNull((Object)root);
        View view = root;
        int id$iv = R.id.file_name;
        boolean $i$f$find2 = false;
        View view2 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        TextView textView = (TextView)view2;
        String string = this.fileName;
        if (string != null) {
            CharSequence charSequence2;
            CharSequence $i$f$find2 = string;
            if (StringsKt.isBlank((CharSequence)$i$f$find2)) {
                TextView textView2 = textView;
                boolean bl = false;
                charSequence2 = "-";
                textView = textView2;
            } else {
                charSequence2 = $i$f$find2;
            }
            charSequence = (String)charSequence2;
        } else {
            charSequence = "-";
        }
        textView.setText(charSequence);
        $this$find$iv = root;
        id$iv = R.id.file_size;
        boolean $i$f$find3 = false;
        View view3 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        ((TextView)view3).setText((CharSequence)ExtensionsKt.formatToSize(properties.getFileSize()));
        $this$find$iv = root;
        id$iv = R.id.title;
        $i$f$find3 = false;
        View view4 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        ((TextView)view4).setText((CharSequence)properties.getTitle());
        $this$find$iv = root;
        id$iv = R.id.subject;
        $i$f$find3 = false;
        View view5 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        ((TextView)view5).setText((CharSequence)properties.getSubject());
        $this$find$iv = root;
        id$iv = R.id.author;
        $i$f$find3 = false;
        View view6 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        ((TextView)view6).setText((CharSequence)properties.getAuthor());
        $this$find$iv = root;
        id$iv = R.id.creator;
        $i$f$find3 = false;
        View view7 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
        ((TextView)view7).setText((CharSequence)properties.getCreator());
        $this$find$iv = root;
        id$iv = R.id.producer;
        $i$f$find3 = false;
        View view8 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(...)");
        ((TextView)view8).setText((CharSequence)properties.getProducer());
        $this$find$iv = root;
        id$iv = R.id.creation_date;
        $i$f$find3 = false;
        View view9 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"findViewById(...)");
        ((TextView)view9).setText((CharSequence)ExtensionsKt.formatToDate(properties.getCreationDate()));
        $this$find$iv = root;
        id$iv = R.id.modified_date;
        $i$f$find3 = false;
        View view10 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"findViewById(...)");
        ((TextView)view10).setText((CharSequence)ExtensionsKt.formatToDate(properties.getModifiedDate()));
        $this$find$iv = root;
        id$iv = R.id.keywords;
        $i$f$find3 = false;
        View view11 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view11, (String)"findViewById(...)");
        ((TextView)view11).setText((CharSequence)properties.getKeywords());
        $this$find$iv = root;
        id$iv = R.id.language;
        $i$f$find3 = false;
        View view12 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view12, (String)"findViewById(...)");
        ((TextView)view12).setText((CharSequence)properties.getLanguage());
        $this$find$iv = root;
        id$iv = R.id.pdf_format_version;
        $i$f$find3 = false;
        View view13 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view13, (String)"findViewById(...)");
        ((TextView)view13).setText((CharSequence)properties.getPdfFormatVersion());
        $this$find$iv = root;
        id$iv = R.id.is_linearized;
        $i$f$find3 = false;
        View view14 = $this$find$iv.findViewById(id$iv);
        Intrinsics.checkNotNullExpressionValue((Object)view14, (String)"findViewById(...)");
        ((TextView)view14).setText((CharSequence)String.valueOf(properties.isLinearized()));
        AlertDialog.Builder builder = $this$setPropertiesView.setView(root);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setView(...)");
        return builder;
    }

    @JvmOverloads
    public PdfToolBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfToolBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final AlertDialog.Builder alertDialogBuilder$lambda$0(Context $context) {
        return new AlertDialog.Builder($context);
    }

    private static final Unit showDialog$lambda$1(Dialog dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        dialog.show();
        return Unit.INSTANCE;
    }

    private static final void setupWith$lambda$4(PdfViewer $pdfViewer, CompoundButton compoundButton, boolean isChecked) {
        $pdfViewer.getEditor().setShowAllHighlights(isChecked);
    }

    private static final void initListeners$lambda$5(PdfToolBar this$0, View it) {
        block1: {
            block5: {
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                if (!this$0.isHighlightBarVisible()) break block0;
                                this$0.setHighlightBarVisible(false);
                                this$0.setEditorBarVisible(true);
                                break block1;
                            }
                            if (!this$0.isFreeTextBarVisible()) break block2;
                            this$0.setFreeTextBarVisible(false);
                            this$0.setEditorBarVisible(true);
                            break block1;
                        }
                        if (!this$0.isInkBarVisible()) break block3;
                        this$0.setInkBarVisible(false);
                        this$0.setEditorBarVisible(true);
                        break block1;
                    }
                    if (!this$0.isEditorBarVisible()) break block4;
                    this$0.setEditorBarVisible(false);
                    break block1;
                }
                if (!this$0.isFindBarVisible()) break block5;
                this$0.setFindBarVisible(false);
                break block1;
            }
            Function0<Unit> function0 = this$0.onBack;
            if (function0 == null) break block1;
            function0.invoke();
        }
    }

    private static final void initListeners$lambda$6(PdfToolBar this$0, View it) {
        this$0.setFindBarVisible(true);
    }

    private static final void initListeners$lambda$7(PdfToolBar this$0, View it) {
        this$0.getPdfViewer().getFindController().findNext();
    }

    private static final void initListeners$lambda$8(PdfToolBar this$0, View it) {
        this$0.getPdfViewer().getFindController().findPrevious();
    }

    private static final void initListeners$lambda$9(PdfToolBar this$0, View it) {
        this$0.setEditorBarVisible(true);
    }

    private static final void initListeners$lambda$10(PdfToolBar this$0, View it) {
        this$0.setHighlightBarVisible(true);
    }

    private static final void initListeners$lambda$11(PdfToolBar this$0, View it) {
        this$0.setFreeTextBarVisible(true);
    }

    private static final void initListeners$lambda$12(PdfToolBar this$0, View it) {
        this$0.setInkBarVisible(true);
    }

    private static final boolean initListeners$lambda$13(PdfToolBar this$0, TextView textView, int actionId, KeyEvent keyEvent) {
        boolean bl;
        if (actionId == 3) {
            String query = ((Object)textView.getText()).toString();
            if (((CharSequence)query).length() > 0) {
                this$0.getPdfViewer().getFindController().startFind(query);
                ExtensionsKt.hideKeyboard((View)this$0.findEditText);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void initListeners$lambda$14(PdfToolBar this$0, View it) {
        this$0.getPdfViewer().getEditor().undo();
    }

    private static final void initListeners$lambda$15(PdfToolBar this$0, View it) {
        this$0.getPdfViewer().getEditor().redo();
    }

    private static final Unit initListeners$lambda$20$lambda$19$lambda$18$lambda$17(PdfToolBar this$0, int newProgress) {
        this$0.getPdfViewer().getEditor().setHighlightThickness(newProgress + 8);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initListeners$lambda$20$lambda$19(PdfToolBar this$0, LinearLayout $this$popup, Function0 it) {
        void $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418;
        TextView $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416;
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$this$popup, (String)"$this$popup");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Context context = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int paddingValue = ExtensionsKt.dpToPx(context, 12);
        TextView textView2 = textView = new TextView($this$popup.getContext());
        LinearLayout linearLayout = $this$popup;
        boolean bl = false;
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416.setText((CharSequence)"Thickness");
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416.setTextColor(this$0.contentColor);
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416.setPadding(paddingValue, paddingValue, paddingValue, paddingValue);
        linearLayout.addView((View)textView);
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2416 = textView = new SeekBar($this$popup.getContext());
        linearLayout = $this$popup;
        boolean bl2 = false;
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setMax(16);
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setProgress(this$0.getPdfViewer().getEditor().getHighlightThickness() - 8);
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)PdfToolBarKt.access$onSeekBarChangeListener(arg_0 -> PdfToolBar.initListeners$lambda$20$lambda$19$lambda$18$lambda$17(this$0, arg_0)));
        if (Build.VERSION.SDK_INT >= 28) {
            $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setOutlineSpotShadowColor(this$0.contentColor);
            $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setOutlineAmbientShadowColor(this$0.contentColor);
        }
        $this$initListeners_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418.setPadding(paddingValue, 0, paddingValue, paddingValue);
        View view = (View)textView;
        Context context2 = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        linearLayout.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ExtensionsKt.dpToPx(context2, 220), -2));
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$20(PdfToolBar this$0, View it) {
        Intrinsics.checkNotNull((Object)it);
        PdfToolBarKt.access$popup(it, this$0.popupBackgroundColor, (arg_0, arg_1) -> PdfToolBar.initListeners$lambda$20$lambda$19(this$0, arg_0, arg_1));
    }

    private static final Unit initListeners$lambda$24$lambda$23$lambda$22(PdfToolBar this$0, Function0 $dismiss, int color) {
        this$0.getPdfViewer().getEditor().setHighlightColor(color);
        this$0.highlightColor.setColor(color);
        $dismiss.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initListeners$lambda$24$lambda$23(PdfToolBar this$0, LinearLayout $this$popup, Function0 dismiss) {
        void $this$initListeners_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421;
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$this$popup, (String)"$this$popup");
        Intrinsics.checkNotNullParameter((Object)dismiss, (String)"dismiss");
        Context context = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int paddingValue = ExtensionsKt.dpToPx(context, 12);
        TextView textView2 = textView = new TextView($this$popup.getContext());
        LinearLayout linearLayout = $this$popup;
        boolean bl = false;
        $this$initListeners_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421.setText((CharSequence)"Highlight Color");
        $this$initListeners_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421.setTextColor(this$0.contentColor);
        $this$initListeners_u24lambda_u2424_u24lambda_u2423_u24lambda_u2421.setPadding(paddingValue, paddingValue, paddingValue, paddingValue);
        linearLayout.addView((View)textView);
        Context context2 = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        $this$popup.addView((View)new ColorItemGrid(context2, this$0.getPdfViewer().getHighlightEditorColors(), this$0.contentColor, (Function1<? super Integer, Unit>)((Function1)arg_0 -> PdfToolBar.initListeners$lambda$24$lambda$23$lambda$22(this$0, dismiss, arg_0))));
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$24(PdfToolBar this$0, View it) {
        Intrinsics.checkNotNull((Object)it);
        PdfToolBarKt.access$popup(it, this$0.popupBackgroundColor, (arg_0, arg_1) -> PdfToolBar.initListeners$lambda$24$lambda$23(this$0, arg_0, arg_1));
    }

    private static final Unit initListeners$lambda$29$lambda$28$lambda$27$lambda$26(PdfToolBar this$0, int newProgress) {
        this$0.getPdfViewer().getEditor().setFreeFontSize(newProgress + 5);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initListeners$lambda$29$lambda$28(PdfToolBar this$0, LinearLayout $this$popup, Function0 it) {
        void $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427;
        TextView $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2425;
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$this$popup, (String)"$this$popup");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Context context = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int paddingValue = ExtensionsKt.dpToPx(context, 12);
        TextView textView2 = textView = new TextView($this$popup.getContext());
        LinearLayout linearLayout = $this$popup;
        boolean bl = false;
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2425.setText((CharSequence)"Font Size");
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2425.setTextColor(this$0.contentColor);
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2425.setPadding(paddingValue, paddingValue, paddingValue, paddingValue);
        linearLayout.addView((View)textView);
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2425 = textView = new SeekBar($this$popup.getContext());
        linearLayout = $this$popup;
        boolean bl2 = false;
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setMax(95);
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setProgress(this$0.getPdfViewer().getEditor().getFreeFontSize() - 5);
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)PdfToolBarKt.access$onSeekBarChangeListener(arg_0 -> PdfToolBar.initListeners$lambda$29$lambda$28$lambda$27$lambda$26(this$0, arg_0)));
        if (Build.VERSION.SDK_INT >= 28) {
            $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setOutlineSpotShadowColor(this$0.contentColor);
            $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setOutlineAmbientShadowColor(this$0.contentColor);
        }
        $this$initListeners_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427.setPadding(paddingValue, 0, paddingValue, paddingValue);
        View view = (View)textView;
        Context context2 = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        linearLayout.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ExtensionsKt.dpToPx(context2, 220), -2));
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$29(PdfToolBar this$0, View it) {
        Intrinsics.checkNotNull((Object)it);
        PdfToolBarKt.access$popup(it, this$0.popupBackgroundColor, (arg_0, arg_1) -> PdfToolBar.initListeners$lambda$29$lambda$28(this$0, arg_0, arg_1));
    }

    private static final Unit initListeners$lambda$31$lambda$30(PdfToolBar this$0, int color) {
        this$0.getPdfViewer().getEditor().setFreeFontColor(color);
        this$0.freeFontColor.setColor(color);
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$31(PdfToolBar this$0, View it) {
        block0: {
            Function1<? super Function1<? super Integer, Unit>, Unit> function1 = this$0.pickColor;
            if (function1 == null) break block0;
            function1.invoke(arg_0 -> PdfToolBar.initListeners$lambda$31$lambda$30(this$0, arg_0));
        }
    }

    private static final Unit initListeners$lambda$36$lambda$35$lambda$34$lambda$33(PdfToolBar this$0, int newProgress) {
        this$0.getPdfViewer().getEditor().setInkThickness(newProgress + 1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initListeners$lambda$36$lambda$35(PdfToolBar this$0, LinearLayout $this$popup, Function0 it) {
        void $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434;
        TextView $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2432;
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$this$popup, (String)"$this$popup");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Context context = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int paddingValue = ExtensionsKt.dpToPx(context, 12);
        TextView textView2 = textView = new TextView($this$popup.getContext());
        LinearLayout linearLayout = $this$popup;
        boolean bl = false;
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2432.setText((CharSequence)"Thickness");
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2432.setTextColor(this$0.contentColor);
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2432.setPadding(paddingValue, paddingValue, paddingValue, paddingValue);
        linearLayout.addView((View)textView);
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2432 = textView = new SeekBar($this$popup.getContext());
        linearLayout = $this$popup;
        boolean bl2 = false;
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setMax(19);
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setProgress(this$0.getPdfViewer().getEditor().getInkThickness() - 1);
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)PdfToolBarKt.access$onSeekBarChangeListener(arg_0 -> PdfToolBar.initListeners$lambda$36$lambda$35$lambda$34$lambda$33(this$0, arg_0)));
        if (Build.VERSION.SDK_INT >= 28) {
            $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setOutlineSpotShadowColor(this$0.contentColor);
            $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setOutlineAmbientShadowColor(this$0.contentColor);
        }
        $this$initListeners_u24lambda_u2436_u24lambda_u2435_u24lambda_u2434.setPadding(paddingValue, 0, paddingValue, paddingValue);
        View view = (View)textView;
        Context context2 = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        linearLayout.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ExtensionsKt.dpToPx(context2, 220), -2));
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$36(PdfToolBar this$0, View it) {
        Intrinsics.checkNotNull((Object)it);
        PdfToolBarKt.access$popup(it, this$0.popupBackgroundColor, (arg_0, arg_1) -> PdfToolBar.initListeners$lambda$36$lambda$35(this$0, arg_0, arg_1));
    }

    private static final Unit initListeners$lambda$41$lambda$40$lambda$39$lambda$38(PdfToolBar this$0, int newProgress) {
        this$0.getPdfViewer().getEditor().setInkOpacity(newProgress + 1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit initListeners$lambda$41$lambda$40(PdfToolBar this$0, LinearLayout $this$popup, Function0 it) {
        void $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439;
        TextView $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2437;
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$this$popup, (String)"$this$popup");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Context context = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        int paddingValue = ExtensionsKt.dpToPx(context, 12);
        TextView textView2 = textView = new TextView($this$popup.getContext());
        LinearLayout linearLayout = $this$popup;
        boolean bl = false;
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2437.setText((CharSequence)"Opacity");
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2437.setTextColor(this$0.contentColor);
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2437.setPadding(paddingValue, paddingValue, paddingValue, paddingValue);
        linearLayout.addView((View)textView);
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2437 = textView = new SeekBar($this$popup.getContext());
        linearLayout = $this$popup;
        boolean bl2 = false;
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setMax(99);
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setProgress(this$0.getPdfViewer().getEditor().getInkOpacity() - 1);
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)PdfToolBarKt.access$onSeekBarChangeListener(arg_0 -> PdfToolBar.initListeners$lambda$41$lambda$40$lambda$39$lambda$38(this$0, arg_0)));
        if (Build.VERSION.SDK_INT >= 28) {
            $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setOutlineSpotShadowColor(this$0.contentColor);
            $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setOutlineAmbientShadowColor(this$0.contentColor);
        }
        $this$initListeners_u24lambda_u2441_u24lambda_u2440_u24lambda_u2439.setPadding(paddingValue, 0, paddingValue, paddingValue);
        View view = (View)textView;
        Context context2 = $this$popup.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        linearLayout.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ExtensionsKt.dpToPx(context2, 220), -2));
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$41(PdfToolBar this$0, View it) {
        Intrinsics.checkNotNull((Object)it);
        PdfToolBarKt.access$popup(it, this$0.popupBackgroundColor, (arg_0, arg_1) -> PdfToolBar.initListeners$lambda$41$lambda$40(this$0, arg_0, arg_1));
    }

    private static final Unit initListeners$lambda$43$lambda$42(PdfToolBar this$0, int color) {
        this$0.getPdfViewer().getEditor().setInkColor(color);
        this$0.inkColor.setColor(color);
        return Unit.INSTANCE;
    }

    private static final void initListeners$lambda$43(PdfToolBar this$0, View it) {
        block0: {
            Function1<? super Function1<? super Integer, Unit>, Unit> function1 = this$0.pickColor;
            if (function1 == null) break block0;
            function1.invoke(arg_0 -> PdfToolBar.initListeners$lambda$43$lambda$42(this$0, arg_0));
        }
    }

    private static final void initSecondaryMenu$lambda$44(PdfToolBar this$0, View it) {
        PopupMenu popupMenu = this$0.getPopupMenu((View)this$0.more);
        popupMenu.setOnMenuItemClickListener(this$0::handlePopupMenuItemClick);
        popupMenu.show();
    }

    private static final boolean addDefaultMenus$lambda$45(PdfToolBarMenuItem it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return true;
    }

    private static final void showZoomDialog$lambda$48(PdfToolBar this$0, String[] $options, DialogInterface dialog, int which) {
        switch (which) {
            case 0: {
                this$0.getPdfViewer().zoomTo(PdfViewer.Zoom.AUTOMATIC);
                break;
            }
            case 1: {
                this$0.getPdfViewer().zoomTo(PdfViewer.Zoom.PAGE_FIT);
                break;
            }
            case 2: {
                this$0.getPdfViewer().zoomTo(PdfViewer.Zoom.PAGE_WIDTH);
                break;
            }
            case 3: {
                this$0.getPdfViewer().zoomTo(PdfViewer.Zoom.ACTUAL_SIZE);
                break;
            }
            default: {
                Float f = StringsKt.toFloatOrNull((String)$options[which]);
                this$0.getPdfViewer().scalePageTo(f != null ? f.floatValue() : 1.0f);
            }
        }
        dialog.dismiss();
    }

    private static final void showZoomDialog$lambda$49(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final Unit showGoToPageDialog$lambda$50(PdfToolBar this$0, String pageNumber, DialogInterface dialog) {
        Intrinsics.checkNotNullParameter((Object)pageNumber, (String)"pageNumber");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Integer n = StringsKt.toIntOrNull((String)pageNumber);
        this$0.getPdfViewer().goToPage(n != null ? n.intValue() : this$0.getPdfViewer().getCurrentPage());
        dialog.dismiss();
        return Unit.INSTANCE;
    }

    private static final void showGoToPageDialog$lambda$51(Function2 $gotTo, EditText $field, DialogInterface dialog, int n) {
        String string = $field.getText().toString();
        Intrinsics.checkNotNull((Object)dialog);
        $gotTo.invoke((Object)string, (Object)dialog);
    }

    private static final void showGoToPageDialog$lambda$52(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final boolean showGoToPageDialog$lambda$53(Function2 $gotTo, EditText $field, AlertDialog $dialog, TextView textView, int actionId, KeyEvent keyEvent) {
        boolean bl;
        if (actionId == 2) {
            $gotTo.invoke((Object)$field.getText().toString(), (Object)$dialog);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void showGoToPageDialog$lambda$55$lambda$54(EditText $field) {
        ExtensionsKt.requestKeyboard($field);
    }

    private static final void showGoToPageDialog$lambda$55(EditText $field, DialogInterface it) {
        $field.postDelayed(() -> PdfToolBar.showGoToPageDialog$lambda$55$lambda$54($field), 500L);
    }

    private static final void showScrollModeDialog$lambda$56(PdfToolBar this$0, String[] $options, DialogInterface dialog, int which) {
        this$0.getPdfViewer().setPageScrollMode(PdfViewer.PageScrollMode.valueOf((String)$options[which]));
        dialog.dismiss();
    }

    private static final void showScrollModeDialog$lambda$57(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showSinglePageArrangementDialog$lambda$58(PdfToolBar this$0, SwitchCompat $switch, DialogInterface dialog, int n) {
        this$0.getPdfViewer().setSinglePageArrangement($switch.isChecked());
        dialog.dismiss();
    }

    private static final void showSinglePageArrangementDialog$lambda$59(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showSpreadModeDialog$lambda$60(PdfToolBar this$0, String[] $options, DialogInterface dialog, int which) {
        this$0.getPdfViewer().setPageSpreadMode(PdfViewer.PageSpreadMode.valueOf((String)$options[which]));
        dialog.dismiss();
    }

    private static final void showSpreadModeDialog$lambda$61(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showAlignModeDialog$lambda$64(PdfToolBar this$0, String[] $options, DialogInterface dialog, int which) {
        this$0.getPdfViewer().setPageAlignMode(PdfViewer.PageAlignMode.valueOf((String)$options[which]));
        dialog.dismiss();
    }

    private static final void showAlignModeDialog$lambda$65(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showSnapPageDialog$lambda$66(PdfToolBar this$0, SwitchCompat $switch, DialogInterface dialog, int n) {
        this$0.getPdfViewer().setSnapPage($switch.isChecked());
        dialog.dismiss();
    }

    private static final void showSnapPageDialog$lambda$67(DialogInterface dialog, int n) {
        dialog.dismiss();
    }

    private static final void showPropertiesDialog$lambda$70(DialogInterface dialog, int n) {
        dialog.dismiss();
    }
}

