/*
 * Decompiled with CFR 0.152.
 */
package com.github.bgalek.security.svg;

import com.github.bgalek.security.svg.InvalidXMLSyntaxException;
import com.github.bgalek.security.svg.NegativeValidationResult;
import com.github.bgalek.security.svg.PositiveValidationResult;
import com.github.bgalek.security.svg.SvgAttributes;
import com.github.bgalek.security.svg.SvgElements;
import com.github.bgalek.security.svg.SvgSecurityValidatorBuilder;
import com.github.bgalek.security.svg.ValidationResult;
import com.github.bgalek.security.svg.XssDetector;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class SvgSecurityValidator
implements XssDetector {
    private static final Pattern JAVASCRIPT_PROTOCOL_IN_CSS_URL = Pattern.compile("url\\(.?javascript");
    private final String[] svgElements;
    private final String[] svgAttributes;
    private final DocumentBuilder xmlParser;

    @Deprecated
    public SvgSecurityValidator() {
        this.svgElements = SvgElements.DEFAULT_SVG_ELEMENTS;
        this.svgAttributes = SvgAttributes.DEFAULT_SVG_ATTRIBUTES;
        this.xmlParser = null;
    }

    SvgSecurityValidator(String[] elements, String[] attributes, DocumentBuilder xmlParser) {
        this.svgElements = elements;
        this.svgAttributes = attributes;
        this.xmlParser = xmlParser;
    }

    public static SvgSecurityValidatorBuilder builder() {
        return new SvgSecurityValidatorBuilder();
    }

    @Override
    public ValidationResult validate(String input) {
        Set<String> offendingElements;
        if (this.xmlParser != null) {
            this.validateXMLSchema(input);
        }
        if ((offendingElements = this.getOffendingElements(input)).isEmpty()) {
            return new NegativeValidationResult();
        }
        return new PositiveValidationResult(offendingElements);
    }

    @Override
    public ValidationResult validate(byte[] input) {
        return this.validate(new String(input, StandardCharsets.UTF_8));
    }

    private void validateXMLSchema(String input) {
        try {
            assert (this.xmlParser != null);
            this.xmlParser.parse(new ByteArrayInputStream(input.getBytes()));
        }
        catch (Exception e) {
            throw new InvalidXMLSyntaxException(e);
        }
    }

    private Set<String> getOffendingElements(String xml) {
        if (JAVASCRIPT_PROTOCOL_IN_CSS_URL.matcher(xml).find()) {
            return Collections.singleton("style");
        }
        PolicyFactory policy = new HtmlPolicyBuilder().allowElements(this.svgElements).allowAttributes(this.svgAttributes).globally().allowUrlProtocols(new String[]{"https"}).toFactory();
        HashSet<String> violations = new HashSet<String>();
        policy.sanitize(xml, SvgSecurityValidator.violationsCollector(), violations);
        return violations;
    }

    private static HtmlChangeListener<Set<String>> violationsCollector() {
        return new ListHtmlChangeListener();
    }

    private static class ListHtmlChangeListener
    implements HtmlChangeListener<Set<String>> {
        private ListHtmlChangeListener() {
        }

        public void discardedTag(Set<String> context, String elementName) {
            Objects.requireNonNull(context).add(elementName);
        }

        public void discardedAttributes(Set<String> context, String tagName, String ... attributeNames) {
            Objects.requireNonNull(context).addAll(Arrays.asList(attributeNames));
        }
    }
}

